/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JavaType {
    public static Map<Integer, Class<?>> jdbcJavaTypes = new HashMap();
    public static Map<Integer, String> mapping = new HashMap<Integer, String>();
    public static Map<String, Integer> jdbcTypeNames = new HashMap<String, Integer>();
    public static int majorJavaVersion = 15;
    public static final String UNKNOW = "UNKNOW";
    public static final String SPECIAL = "SPECIAL";

    public static boolean isDateType(Integer sqlType) {
        return sqlType == 91 || sqlType == 92 || sqlType == 2013 || sqlType == 93 || sqlType == 2014;
    }

    public static boolean isInteger(Integer sqlType) {
        return sqlType == 16 || sqlType == -7 || sqlType == 4 || sqlType == -6 || sqlType == 5;
    }

    public static String getType(Integer sqlType, Integer size, Integer digit) {
        String type = mapping.get(sqlType);
        if (type.equals(SPECIAL)) {
            if (digit != null && digit != 0) {
                return "Double";
            }
            if (size >= 9) {
                return "Long";
            }
            return "Integer";
        }
        return type;
    }

    public static boolean isJavaNumberType(int jdbcType) {
        Class<?> type = jdbcJavaTypes.get(jdbcType);
        return type == null ? false : Number.class.isAssignableFrom(type);
    }

    public static boolean isJdk8() {
        return majorJavaVersion >= 18;
    }

    static {
        String javaVersion = System.getProperty("java.version");
        majorJavaVersion = javaVersion.startsWith("11") ? 21 : (javaVersion.startsWith("10") ? 20 : (javaVersion.startsWith("9") ? 19 : (javaVersion.startsWith("1.8.") ? 18 : (javaVersion.contains("1.7.") ? 17 : (javaVersion.contains("1.6.") ? 16 : 15)))));
        jdbcJavaTypes.put(new Integer(-16), String.class);
        jdbcJavaTypes.put(new Integer(-15), String.class);
        jdbcJavaTypes.put(new Integer(-9), String.class);
        jdbcJavaTypes.put(new Integer(-8), String.class);
        jdbcJavaTypes.put(new Integer(-7), Boolean.class);
        jdbcJavaTypes.put(new Integer(-6), Integer.class);
        jdbcJavaTypes.put(new Integer(-5), Long.class);
        jdbcJavaTypes.put(new Integer(-4), byte[].class);
        jdbcJavaTypes.put(new Integer(-3), byte[].class);
        jdbcJavaTypes.put(new Integer(-2), byte[].class);
        jdbcJavaTypes.put(new Integer(-1), String.class);
        jdbcJavaTypes.put(new Integer(1), String.class);
        jdbcJavaTypes.put(new Integer(2), BigDecimal.class);
        jdbcJavaTypes.put(new Integer(3), BigDecimal.class);
        jdbcJavaTypes.put(new Integer(4), Integer.class);
        jdbcJavaTypes.put(new Integer(5), Integer.class);
        jdbcJavaTypes.put(new Integer(6), BigDecimal.class);
        jdbcJavaTypes.put(new Integer(7), BigDecimal.class);
        jdbcJavaTypes.put(new Integer(8), BigDecimal.class);
        jdbcJavaTypes.put(new Integer(12), String.class);
        jdbcJavaTypes.put(new Integer(16), Boolean.class);
        jdbcJavaTypes.put(new Integer(91), Date.class);
        jdbcJavaTypes.put(new Integer(92), Time.class);
        jdbcJavaTypes.put(new Integer(93), Timestamp.class);
        jdbcJavaTypes.put(new Integer(1111), Object.class);
        jdbcJavaTypes.put(new Integer(2004), byte[].class);
        jdbcJavaTypes.put(new Integer(2005), String.class);
        jdbcJavaTypes.put(new Integer(2009), SQLXML.class);
        jdbcJavaTypes.put(new Integer(2011), String.class);
        mapping.put(-5, "Long");
        mapping.put(-2, "byte[]");
        mapping.put(-7, "Integer");
        mapping.put(2004, "byte[]");
        mapping.put(16, "Integer");
        mapping.put(1, "String");
        mapping.put(2005, "String");
        mapping.put(70, UNKNOW);
        mapping.put(91, "Date");
        mapping.put(3, SPECIAL);
        mapping.put(2001, UNKNOW);
        mapping.put(8, "Double");
        mapping.put(6, "Float");
        mapping.put(4, "Integer");
        mapping.put(2000, UNKNOW);
        mapping.put(-16, "String");
        mapping.put(-4, "byte[]");
        mapping.put(-1, "String");
        mapping.put(-15, "String");
        mapping.put(-9, "String");
        mapping.put(2011, "String");
        mapping.put(0, UNKNOW);
        mapping.put(2, SPECIAL);
        mapping.put(1111, "Object");
        mapping.put(7, "Double");
        mapping.put(2006, UNKNOW);
        mapping.put(5, "Integer");
        mapping.put(2009, "SQLXML");
        mapping.put(2002, UNKNOW);
        mapping.put(92, "Date");
        mapping.put(93, "Timestamp");
        mapping.put(-6, "Integer");
        mapping.put(-3, "byte[]");
        mapping.put(12, "String");
        if (majorJavaVersion >= 18) {
            mapping.put(2012, UNKNOW);
            mapping.put(2014, "Timestamp");
            mapping.put(2013, "Timestamp");
        }
        Field[] fields = Types.class.getFields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                String name = fields[i].getName().toLowerCase();
                Integer value = (Integer)fields[i].get(Types.class);
                jdbcTypeNames.put(name, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

