/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordReplicationInfo;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation {
    private Map<String, Set<RecordReplicationInfo>> data;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(MapService mapService, PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
            String name = (String)entry.getKey();
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>();
            for (Map.Entry<Data, Record> recordEntry : recordStore.getReadonlyRecordMap().entrySet()) {
                Data key = recordEntry.getKey();
                Record record = recordEntry.getValue();
                RecordReplicationInfo recordReplicationInfo = mapService.createRecordReplicationInfo(mapContainer, record);
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(name, recordSet);
        }
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        if (this.data != null) {
            for (Map.Entry<String, Set<RecordReplicationInfo>> dataEntry : this.data.entrySet()) {
                Set<RecordReplicationInfo> recordReplicationInfos = dataEntry.getValue();
                String mapName = dataEntry.getKey();
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), mapName);
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Data key = recordReplicationInfo.getKey();
                    Record newRecord = mapService.createRecord(mapName, key, recordReplicationInfo.getValue(), -1L, false);
                    mapService.applyRecordInfo(newRecord, mapName, recordReplicationInfo);
                    Record existingRecord = recordStore.putRecord(key, newRecord);
                    SizeEstimator sizeEstimator = recordStore.getSizeEstimator();
                    this.updateSizeEstimator(-this.calculateRecordSize(existingRecord, sizeEstimator), sizeEstimator);
                    this.updateSizeEstimator(this.calculateRecordSize(newRecord, sizeEstimator), sizeEstimator);
                }
                recordStore.setLoaded(true);
            }
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (int j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> mapEntry : this.data.entrySet()) {
            out.writeUTF(mapEntry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = mapEntry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    private void updateSizeEstimator(long recordSize, SizeEstimator sizeEstimator) {
        sizeEstimator.add(recordSize);
    }

    private long calculateRecordSize(Record record, SizeEstimator sizeEstimator) {
        return sizeEstimator.getCost(record);
    }
}

