/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.tableconfig.model;

import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.ext.tableconfig.IbatisSqlMapConfigParser;
import cn.org.rapid_framework.generator.provider.db.sql.SqlFactory;
import cn.org.rapid_framework.generator.provider.db.sql.model.Sql;
import cn.org.rapid_framework.generator.provider.db.sql.model.SqlParameter;
import cn.org.rapid_framework.generator.provider.db.sql.model.SqlSegment;
import cn.org.rapid_framework.generator.provider.db.table.TableFactory;
import cn.org.rapid_framework.generator.provider.db.table.model.Column;
import cn.org.rapid_framework.generator.provider.db.table.model.ColumnSet;
import cn.org.rapid_framework.generator.provider.db.table.model.Table;
import cn.org.rapid_framework.generator.util.BeanHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.sqlparse.SqlParseHelper;
import cn.org.rapid_framework.generator.util.typemapping.JavaPrimitiveTypeMapping;
import cn.org.rapid_framework.generator.util.typemapping.JdbcType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConfig {
    public String sqlName;
    public String sequence;
    public String dummyPk;
    public String remarks;
    public String subPackage;
    public String _package;
    public boolean autoSwitchDataSrc;
    public String className;
    public List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    public List<OperationConfig> operations = new ArrayList<OperationConfig>();
    public List<ResultMapConfig> resultMaps = new ArrayList<ResultMapConfig>();
    private List<SqlConfig> includeSqls = new ArrayList<SqlConfig>();
    private Table table = null;
    private List<Sql> sqls;

    public List<ResultMapConfig> getResultMaps() {
        return this.resultMaps;
    }

    public void setResultMaps(List<ResultMapConfig> resultMaps) {
        this.resultMaps = resultMaps;
    }

    public String getClassName() {
        if (StringHelper.isNotBlank((String)this.className)) {
            return this.className;
        }
        if (StringHelper.isBlank((String)this.sqlName)) {
            return null;
        }
        return StringHelper.toJavaClassName((String)this.sqlName);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Column getPkColumn() throws Exception {
        if (StringHelper.isBlank((String)this.dummyPk)) {
            return this.getTable().getPkColumn();
        }
        return this.getTable().getColumnByName(this.dummyPk);
    }

    public String getPackage() {
        if (StringHelper.isBlank((String)this.subPackage)) {
            return this._package;
        }
        return this._package + "." + this.subPackage;
    }

    public void setPackage(String pkg) {
        this._package = pkg;
    }

    public Table getTable() throws Exception {
        if (this.table != null) {
            return this.table;
        }
        this.table = TableFactory.getInstance().getTable(this.getSqlName());
        return this.customTable(this.table);
    }

    public Table customTable(Table table) {
        Column c;
        if (!table.getSqlName().equalsIgnoreCase(this.getSqlName())) {
            throw new RuntimeException("cannot custom table properties,sqlName not equals. tableConfig.sqlName:" + this.getSqlName() + " table.sqlName:" + table.getSqlName());
        }
        if (this.columns != null) {
            for (ColumnConfig c2 : this.columns) {
                Column tableColumn = table.getColumnByName(c2.getName());
                if (tableColumn == null) continue;
                tableColumn.setJavaType(c2.getJavatype());
            }
        }
        if (StringHelper.isNotBlank((String)this.getDummyPk()) && (c = table.getColumnBySqlName(this.getDummyPk())) != null) {
            c.setPk(true);
        }
        table.setClassName(this.getClassName());
        if (StringHelper.isNotBlank((String)this.remarks)) {
            table.setTableAlias(this.remarks);
        }
        return table;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlname) {
        this.sqlName = sqlname;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public List<ColumnConfig> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnConfig>();
        }
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> column) {
        this.columns = column;
    }

    public List<SqlConfig> getIncludeSqls() {
        return this.includeSqls;
    }

    public void setIncludeSqls(List<SqlConfig> includeSqls) {
        this.includeSqls = includeSqls;
    }

    public void addSqlConfig(SqlConfig c) {
        this.includeSqls.add(c);
        c.setTableConfig(this);
    }

    public List<OperationConfig> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationConfig> operations) {
        this.operations = operations;
    }

    public OperationConfig findOperation(String operationName) {
        Object operation = null;
        for (OperationConfig item : this.getOperations()) {
            if (!item.getName().equals(operationName)) continue;
            return item;
        }
        return null;
    }

    public String getDummyPk() {
        return this.dummyPk;
    }

    public void setDummyPk(String dummypk) {
        this.dummyPk = dummypk;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSubPackage() {
        return this.subPackage;
    }

    public void setSubPackage(String subpackage) {
        this.subPackage = subpackage;
    }

    public boolean isAutoSwitchDataSrc() {
        return this.autoSwitchDataSrc;
    }

    public void setAutoSwitchDataSrc(boolean autoswitchdatasrc) {
        this.autoSwitchDataSrc = autoswitchdatasrc;
    }

    public void setDoName(String doname) {
        this.className = doname;
    }

    public String getBasepackage() {
        return this.getPackage();
    }

    public String toString() {
        return "sqlname:" + this.sqlName;
    }

    public List<Sql> getSqls() {
        if (this.sqls == null) {
            this.sqls = TableConfig.toSqls(this);
        }
        return this.sqls;
    }

    public static List<Sql> toSqls(TableConfig table) {
        return new Convert2SqlsProecssor().toSqls(table);
    }

    public OperationConfig getOperation(String name) {
        for (OperationConfig op : this.operations) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OperationConfig {
        public List<ParamConfig> extraparams = new ArrayList<ParamConfig>();
        public String name;
        public String resultClass;
        public String resultMap;
        public String parameterClass;
        public String remarks;
        public String multiplicity;
        public String paramtype;
        public String sql;
        public String sqlmap;
        public Sql parsedSql;
        public boolean paging = false;
        public String append = "";
        public String appendXmlAttributes = "";

        public List<ParamConfig> getExtraparams() {
            return this.extraparams;
        }

        public void setExtraparams(List<ParamConfig> extraparams) {
            this.extraparams = extraparams;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResultClass() {
            return this.resultClass;
        }

        public void setResultClass(String resultClass) {
            this.resultClass = resultClass;
        }

        public String getParameterClass() {
            return this.parameterClass;
        }

        public void setParameterClass(String parameterClass) {
            this.parameterClass = parameterClass;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public String getMultiplicity() {
            return this.multiplicity;
        }

        public void setMultiplicity(String multiplicity) {
            this.multiplicity = multiplicity;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getSqlmap() {
            return this.sqlmap;
        }

        public void setSqlmap(String sqlmap) {
            this.sqlmap = sqlmap;
        }

        public String getParamtype() {
            return this.paramtype;
        }

        public void setParamtype(String paramtype) {
            this.paramtype = paramtype;
        }

        public boolean isPaging() {
            return this.paging;
        }

        public void setPaging(boolean paging) {
            this.paging = paging;
        }

        public String getResultMap() {
            return this.resultMap;
        }

        public void setResultMap(String resultMap) {
            this.resultMap = resultMap;
        }

        public String getAppend() {
            return this.append;
        }

        public void setAppend(String append) {
            this.append = append;
        }

        public String toString() {
            return BeanHelper.describe((Object)this, (String[])new String[0]).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResultMapConfig {
        private String name;
        private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<ColumnConfig> getColumns() {
            return this.columns;
        }

        public void setColumns(List<ColumnConfig> columns) {
            this.columns = columns;
        }
    }

    public static class ParamConfig
    extends ColumnConfig {
    }

    public static class ColumnConfig {
        private String name;
        private String javatype;
        private String columnAlias;
        private String nullValue;

        public String getName() {
            return this.name;
        }

        public void setName(String sqlname) {
            this.name = sqlname;
        }

        public String getJavatype() {
            return this.javatype;
        }

        public void setJavatype(String javatype) {
            this.javatype = javatype;
        }

        public String getColumnAlias() {
            return this.columnAlias;
        }

        public void setColumnAlias(String columnAlias) {
            this.columnAlias = columnAlias;
        }

        public void setNullValue(String nullValue) {
            this.nullValue = nullValue;
        }

        public String getNullValue() {
            if (StringHelper.isBlank((String)this.nullValue)) {
                return JavaPrimitiveTypeMapping.getDefaultValue((String)this.javatype);
            }
            return this.nullValue;
        }

        public boolean isHasNullValue() {
            return JavaPrimitiveTypeMapping.getWrapperTypeOrNull((String)this.javatype) != null;
        }

        public String toString() {
            return BeanHelper.describe((Object)this, (String[])new String[0]).toString();
        }
    }

    public static class SqlConfig {
        String id;
        String sql;
        private TableConfig tableConfig;

        public String toString() {
            return String.format("<sql id='%s'>%s</sql>", this.id, this.sql);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public TableConfig getTableConfig() {
            return this.tableConfig;
        }

        public void setTableConfig(TableConfig tableConfig) {
            this.tableConfig = tableConfig;
        }

        public SqlSegment getSqlSegment() {
            if (this.tableConfig == null) {
                throw new IllegalArgumentException("tableConfig must be not null");
            }
            for (Sql sql : this.tableConfig.getSqls()) {
                if (sql.getSqlSegment(this.id) == null) continue;
                return sql.getSqlSegment(this.id);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Convert2SqlsProecssor {
        Convert2SqlsProecssor() {
        }

        public List<Sql> toSqls(TableConfig table) {
            ArrayList<Sql> sqls = new ArrayList<Sql>();
            for (OperationConfig op : table.getOperations()) {
                sqls.add(this.processOperation(op, table));
            }
            return sqls;
        }

        public Sql toSql(TableConfig table, String operationName) {
            OperationConfig operation = table.findOperation(operationName);
            if (operation == null) {
                throw new IllegalArgumentException("not found operation with name:" + operationName);
            }
            return this.processOperation(operation, table);
        }

        private Sql processOperation(OperationConfig op, TableConfig table) {
            try {
                IbatisSqlMapConfigParser ibatisSqlMapConfigParser = new IbatisSqlMapConfigParser();
                String sqlString = ibatisSqlMapConfigParser.parse(op.getSql(), Convert2SqlsProecssor.toMap(table.includeSqls));
                String namedSql = SqlParseHelper.convert2NamedParametersSql((String)sqlString, (String)":", (String)"");
                Sql sql = new SqlFactory().parseSql(namedSql);
                sql.setSqlSegments(ibatisSqlMapConfigParser.getSqlSegments());
                LinkedHashSet<SqlParameter> finalParameters = Convert2SqlsProecssor.addExtraParams2SqlParams(op.getExtraparams(), sql);
                sql.setParams(finalParameters);
                sql.setColumns(Convert2SqlsProecssor.processWithCustomColumns(Convert2SqlsProecssor.getCustomColumns(table), sql.getColumns()));
                String ibatisSql = Convert2SqlsProecssor.getIbatisSql(op, sql);
                sql.setIbatisSql(ibatisSql);
                sql.setMybatisSql(sql.replaceWildcardWithColumnsSqlName(SqlParseHelper.convert2NamedParametersSql((String)op.getSql(), (String)"#{", (String)"}")) + " " + op.getAppend());
                sql.setOperation(op.getName());
                sql.setParameterClass(op.getParameterClass());
                sql.setResultClass(op.getResultClass());
                sql.setRemarks(op.getRemarks());
                sql.setPaging(op.isPaging());
                sql.setSqlmap(op.getSqlmap());
                sql.setResultMap(op.getResultMap());
                if (StringHelper.isNotBlank((String)op.getMultiplicity())) {
                    sql.setMultiplicity(op.getMultiplicity());
                }
                if (StringHelper.isNotBlank((String)op.getParamtype())) {
                    sql.setParamType(op.getParamtype());
                } else if (StringHelper.isBlank((String)op.getParamtype()) && (sql.isSelectSql() || sql.isDeleteSql())) {
                    sql.setParamType(Sql.PARAMTYPE_PRIMITIVE);
                }
                sql.afterPropertiesSet();
                return this.afterProcessed(sql, op, table);
            }
            catch (Exception e) {
                throw new RuntimeException("parse sql error on table:" + table.getSqlName() + " operation:" + op.getName() + "() sql:" + op.getSql(), e);
            }
        }

        protected Sql afterProcessed(Sql sql, OperationConfig op, TableConfig table) {
            return sql;
        }

        private static String getIbatisSql(OperationConfig op, Sql sql) {
            String ibatisNamedSql = sql.replaceWildcardWithColumnsSqlName(SqlParseHelper.convert2NamedParametersSql((String)op.getSql(), (String)"#", (String)"#")) + " " + StringHelper.defaultString((Object)op.getAppend());
            String ibatisSql = Convert2SqlsProecssor.processSqlForMoneyParam(ibatisNamedSql, sql.getParams());
            return ibatisSql;
        }

        private static LinkedHashSet<Column> processWithCustomColumns(List<Column> customColumns, LinkedHashSet<Column> columns) {
            ColumnSet columnSet = new ColumnSet(customColumns);
            for (Column c : columns) {
                Column custom = columnSet.getBySqlName(c.getSqlName());
                if (custom == null) continue;
                c.setJavaType(custom.getJavaType());
            }
            return columns;
        }

        private static LinkedHashSet<SqlParameter> addExtraParams2SqlParams(List<ParamConfig> extraParams, Sql sql) {
            LinkedHashSet<SqlParameter> filterdExtraParameters = new LinkedHashSet<SqlParameter>();
            for (ParamConfig extraParam : extraParams) {
                SqlParameter param = sql.getParam(extraParam.getName());
                if (param == null) {
                    SqlParameter extraparam = new SqlParameter();
                    extraparam.setParameterClass(extraParam.getJavatype());
                    if (StringHelper.isNotBlank((String)extraParam.getColumnAlias())) {
                        extraparam.setColumnAlias(extraParam.getColumnAlias());
                    }
                    extraparam.setParamName(extraParam.getName());
                    filterdExtraParameters.add(extraparam);
                    continue;
                }
                param.setParameterClass(extraParam.getJavatype());
                if (!StringHelper.isNotBlank((String)extraParam.getColumnAlias())) continue;
                param.setColumnAlias(extraParam.getColumnAlias());
            }
            if (GeneratorProperties.getBoolean((String)"generator.extraParams.append", (boolean)true)) {
                LinkedHashSet<SqlParameter> result = new LinkedHashSet<SqlParameter>(sql.getParams());
                result.addAll(filterdExtraParameters);
                return result;
            }
            filterdExtraParameters.addAll(sql.getParams());
            return filterdExtraParameters;
        }

        private static String processSqlForMoneyParam(String ibatisSql, LinkedHashSet<SqlParameter> params) {
            for (SqlParameter p : params) {
                if (!p.getParameterClass().endsWith("Money")) continue;
                ibatisSql = StringHelper.replace((String)ibatisSql, (String)("#" + p.getParamName() + "#"), (String)("#" + p.getParamName() + ".cent" + "#"));
            }
            return ibatisSql;
        }

        private static Map<String, String> toMap(List<SqlConfig> sql) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (SqlConfig s : sql) {
                map.put(s.id, s.sql);
            }
            return map;
        }

        private static List<Column> getCustomColumns(TableConfig table) throws Exception {
            ArrayList<Column> result = new ArrayList<Column>();
            Table t = table.getTable();
            for (ColumnConfig mc : table.getColumns()) {
                Column c = t.getColumnByName(mc.getName());
                if (c == null) {
                    c = new Column(null, JdbcType.UNDEFINED.TYPE_CODE, "UNDEFINED", mc.getName(), -1, -1, false, false, false, false, "", mc.getColumnAlias());
                }
                c.setJavaType(mc.getJavatype());
                if (StringHelper.isNotBlank((String)mc.getColumnAlias())) {
                    c.setColumnAlias(mc.getColumnAlias());
                }
                result.add(c);
            }
            return result;
        }
    }
}

