/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.tableconfig.builder;

import cn.org.rapid_framework.generator.GeneratorConstants;
import cn.org.rapid_framework.generator.GeneratorProperties;
import cn.org.rapid_framework.generator.ext.tableconfig.model.TableConfig;
import cn.org.rapid_framework.generator.ext.tableconfig.model.TableConfigSet;
import cn.org.rapid_framework.generator.util.BeanHelper;
import cn.org.rapid_framework.generator.util.IOHelper;
import cn.org.rapid_framework.generator.util.StringHelper;
import cn.org.rapid_framework.generator.util.XMLHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConfigXmlBuilder {
    public TableConfigSet parseFromXML(String _package, File basedir, String tableConfigFiles) {
        String[] tableConfigFilesArray = StringHelper.tokenizeToStringArray((String)tableConfigFiles, (String)", \t\n\r\f");
        TableConfigSet tableConfigSet = new TableConfigXmlBuilder().parseFromXML(basedir, _package, Arrays.asList(tableConfigFilesArray));
        return tableConfigSet;
    }

    public TableConfigSet parseFromXML(File basedir, String _package, List<String> tableConfigFiles) {
        TableConfigSet result = new TableConfigSet();
        result.setPackage(_package);
        for (String filepath : tableConfigFiles) {
            File file = new File(basedir, filepath);
            result.addTableConfig(this.parseFromXML(file));
        }
        return result;
    }

    public TableConfig parseFromXML(File file) {
        TableConfig tableConfig;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            tableConfig = this.parseFromXML(in);
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException("parse file:" + file.getAbsolutePath() + " occer error", e);
            }
            catch (Throwable throwable) {
                IOHelper.close(in, null);
                throw throwable;
            }
        }
        IOHelper.close((InputStream)in, null);
        return tableConfig;
    }

    public TableConfig parseFromXML(InputStream inputStream) throws SAXException, IOException {
        XMLHelper.NodeData nodeData = new XMLHelper().parseXML(inputStream);
        TableConfig config = new TableConfig();
        BeanHelper.copyProperties((Object)config, (Map)nodeData.attributes, (boolean)true);
        for (XMLHelper.NodeData child : nodeData.childs) {
            Object target;
            if ("operation".equals(child.nodeName)) {
                target = new TableConfig.OperationConfig();
                BeanHelper.copyProperties((Object)target, (Map)child.attributes, (boolean)true);
                for (XMLHelper.NodeData opChild : child.childs) {
                    if ("extraparams".equals(opChild.nodeName)) {
                        for (XMLHelper.NodeData paramNode : opChild.childs) {
                            TableConfig.ParamConfig mp = new TableConfig.ParamConfig();
                            BeanHelper.copyProperties((Object)mp, (Map)paramNode.attributes, (boolean)true);
                            ((TableConfig.OperationConfig)target).extraparams.add(mp);
                        }
                        continue;
                    }
                    BeanHelper.setProperty((Object)target, (String)opChild.nodeName, (Object)this.getNodeValue(opChild));
                }
                config.operations.add((TableConfig.OperationConfig)target);
            }
            if ("column".equals(child.nodeName)) {
                target = new TableConfig.ColumnConfig();
                BeanHelper.copyProperties((Object)target, (Map)child.attributes, (boolean)true);
                config.columns.add((TableConfig.ColumnConfig)target);
            }
            if ("sql".equals(child.nodeName)) {
                target = new TableConfig.SqlConfig();
                BeanHelper.copyProperties((Object)target, (Map)child.attributes, (boolean)true);
                ((TableConfig.SqlConfig)target).setSql(this.getNodeValue(child));
                config.addSqlConfig((TableConfig.SqlConfig)target);
            }
            if (!"resultmap".equals(child.nodeName)) continue;
            target = new TableConfig.ResultMapConfig();
            BeanHelper.copyProperties((Object)target, (Map)child.attributes, (boolean)true);
            for (XMLHelper.NodeData c : child.childs) {
                if (!"column".equals(c.nodeName)) continue;
                TableConfig.ColumnConfig column = new TableConfig.ColumnConfig();
                BeanHelper.copyProperties((Object)column, (Map)c.attributes, (boolean)true);
                ((TableConfig.ResultMapConfig)target).getColumns().add(column);
            }
            config.resultMaps.add((TableConfig.ResultMapConfig)target);
        }
        return config;
    }

    public String getNodeValue(XMLHelper.NodeData v) {
        if (GeneratorProperties.getBoolean((GeneratorConstants)GeneratorConstants.USE_INNER_XML_FOR_XML_PARSING)) {
            return v.innerXML;
        }
        return v.nodeValue;
    }
}

