/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.generator.ext.ant;

import cn.org.rapid_framework.generator.ext.ant.BaseGeneratorTask;
import cn.org.rapid_framework.generator.ext.tableconfig.builder.TableConfigXmlBuilder;
import cn.org.rapid_framework.generator.ext.tableconfig.model.TableConfigSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseTableConfigSetTask
extends BaseGeneratorTask {
    private String tableConfigFiles;
    protected TableConfigSet tableConfigSet;
    private static ThreadLocal<Map> threadLocalCache = new ThreadLocal();

    protected void executeBefore() throws Exception {
        super.executeBefore();
        if (this.tableConfigFiles == null || "".equals(this.tableConfigFiles.trim())) {
            throw new Exception("'tableConfigFiles' must be not null");
        }
        if (this.tableConfigSet == null) {
            Map cache = BaseTableConfigSetTask.getThreadLocalCache();
            this.tableConfigSet = (TableConfigSet)cache.get(this.tableConfigFiles);
            if (this.tableConfigSet == null) {
                this.tableConfigSet = BaseTableConfigSetTask.parseForTableConfigSet(this.getPackage(), this.getProject().getBaseDir().getAbsoluteFile(), this.tableConfigFiles);
            }
            cache.put(this.tableConfigFiles, this.tableConfigSet);
        }
    }

    public static Map getThreadLocalCache() {
        HashMap map = threadLocalCache.get();
        if (map == null) {
            map = new HashMap();
            threadLocalCache.set(map);
        }
        return map;
    }

    public void setTableConfigFiles(String tableConfigFiles) {
        this.tableConfigFiles = tableConfigFiles;
    }

    static TableConfigSet parseForTableConfigSet(String _package, File basedir, String tableConfigFiles) {
        return new TableConfigXmlBuilder().parseFromXML(_package, basedir, tableConfigFiles);
    }
}

