/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpResponseProxy;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpMediaDownloadRequestExecutor
extends MediaDownloadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public OkHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam) throws WxErrorException, IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String contentType;
        this.logger.debug("OkHttpMediaDownloadRequestExecutor is running");
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        if ((contentType = (response = (client = (OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request = new Request.Builder().url(uri).get().build()).execute()).header("Content-Type")) != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.body().string()));
        }
        String fileName = new HttpResponseProxy(response).getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        File file = File.createTempFile(FilenameUtils.getBaseName((String)fileName), FilenameUtils.getExtension((String)fileName), this.tmpDirFile);
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));){
            sink.writeAll((Source)response.body().source());
        }
        file.deleteOnExit();
        return file;
    }
}

