/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.config;

import com.reger.dubbo.config.CompositePropertySources;
import com.reger.dubbo.config.FilteredPropertySources;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;

class PropertySourcesDeducer {
    private static final Log logger = LogFactory.getLog(PropertySourcesDeducer.class);
    private final ApplicationContext applicationContext;

    PropertySourcesDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PropertySources getPropertySources() {
        MutablePropertySources environmentPropertySources = this.extractEnvironmentPropertySources();
        PropertySourcesPlaceholderConfigurer placeholderConfigurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (placeholderConfigurer == null) {
            Assert.state((environmentPropertySources != null ? 1 : 0) != 0, (String)"Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
            return environmentPropertySources;
        }
        PropertySources appliedPropertySources = placeholderConfigurer.getAppliedPropertySources();
        if (environmentPropertySources == null) {
            return appliedPropertySources;
        }
        return this.merge((PropertySources)environmentPropertySources, appliedPropertySources);
    }

    private MutablePropertySources extractEnvironmentPropertySources() {
        Environment environment = this.applicationContext.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)environment).getPropertySources();
        }
        return null;
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        Map beans = this.applicationContext.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
        if (beans.size() == 1) {
            return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
        }
        if (beans.size() > 1 && logger.isWarnEnabled()) {
            logger.warn((Object)("Multiple PropertySourcesPlaceholderConfigurer beans registered " + beans.keySet() + ", falling back to Environment"));
        }
        return null;
    }

    private PropertySources merge(PropertySources environmentPropertySources, PropertySources appliedPropertySources) {
        FilteredPropertySources filtered = new FilteredPropertySources(appliedPropertySources, "environmentProperties");
        return new CompositePropertySources(filtered, environmentPropertySources);
    }
}

