/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.config;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.InjectAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.context.annotation.DubboClassPathBeanDefinitionScanner;
import com.alibaba.dubbo.config.spring.util.BeanRegistrar;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationBean
extends AbstractConfig
implements DisposableBean,
BeanFactoryPostProcessor,
ResourceLoaderAware,
EnvironmentAware,
BeanClassLoaderAware {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(AnnotationBean.class);
    protected BeanDefinitionRegistry registry;
    private ResourceLoader resourceLoader;
    private Environment environment;
    private ClassLoader classLoader;
    private String[] annotationPackages;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.registry = (BeanDefinitionRegistry)beanFactory;
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)this.registry, (String)InjectAnnotationBeanPostProcessor.BEAN_NAME, InjectAnnotationBeanPostProcessor.class);
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)this.registry, (String)"referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class);
    }

    public void setPackage(String annotationPackage) {
        this.annotationPackages = StringUtils.hasText((String)annotationPackage) ? this.trims(annotationPackage) : new String[0];
    }

    protected void postProcessAnnotationPackageService() {
        if (this.annotationPackages.length == 0) {
            return;
        }
        DubboClassPathBeanDefinitionScanner definitionScanner = new DubboClassPathBeanDefinitionScanner(this.registry, this.environment, this.resourceLoader);
        definitionScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Service.class));
        Set definitionHolders = definitionScanner.doScan(this.annotationPackages);
        for (BeanDefinitionHolder definitionHolder : definitionHolders) {
            this.registerServiceBean(definitionHolder, this.registry);
        }
        this.logger.debug("{} annotated @Service Components { {} } were scanned under package[{}]", new Object[]{definitionHolders.size(), definitionHolders, this.annotationPackages});
    }

    private void registerServiceBean(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry registry) {
        Class<?> beanClass = this.resolveClass(beanDefinitionHolder);
        Service service = (Service)AnnotationUtils.findAnnotation(beanClass, Service.class);
        Class<?> interfaceClass = this.resolveServiceInterfaceClass(beanClass, service);
        String beanName = beanDefinitionHolder.getBeanName();
        if (interfaceClass == null) {
            Class<?>[] interfacess = beanClass.getInterfaces();
            Assert.isTrue((interfacess.length != 0 ? 1 : 0) != 0, (String)(beanClass + "\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u4e0d\u53ef\u4ee5\u53d1\u5e03\u670d\u52a1"));
            for (Class<?> interfaces : interfacess) {
                AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(service, interfaces, beanName);
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)serviceBeanDefinition, (BeanDefinitionRegistry)registry);
            }
        } else {
            AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(service, interfaceClass, beanName);
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)serviceBeanDefinition, (BeanDefinitionRegistry)registry);
        }
    }

    private ManagedList<RuntimeBeanReference> toRuntimeBeanReferences(String ... beanNames) {
        ManagedList runtimeBeanReferences = new ManagedList();
        if (!ObjectUtils.isEmpty((Object[])beanNames)) {
            for (String beanName : beanNames) {
                runtimeBeanReferences.add((Object)new RuntimeBeanReference(beanName));
            }
        }
        return runtimeBeanReferences;
    }

    private AbstractBeanDefinition buildServiceBeanDefinition(Service service, Class<?> interfaceClass, String annotatedServiceBeanName) {
        String[] registryConfigBeanNames;
        ManagedList<RuntimeBeanReference> registryRuntimeBeanReferences;
        String moduleConfigBeanName;
        String applicationConfigBeanName;
        String monitorConfigBeanName;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServiceBean.class).addConstructorArgValue((Object)service).addPropertyReference("ref", annotatedServiceBeanName).addPropertyValue("interfaceClass", interfaceClass);
        String providerConfigBeanName = service.provider();
        if (StringUtils.hasText((String)providerConfigBeanName)) {
            builder.addPropertyReference("provider", providerConfigBeanName);
        }
        if (StringUtils.hasText((String)(monitorConfigBeanName = service.monitor()))) {
            builder.addPropertyReference("monitor", monitorConfigBeanName);
        }
        if (StringUtils.hasText((String)(applicationConfigBeanName = service.application()))) {
            builder.addPropertyReference("application", applicationConfigBeanName);
        }
        if (StringUtils.hasText((String)(moduleConfigBeanName = service.module()))) {
            builder.addPropertyReference("application", moduleConfigBeanName);
        }
        if (!(registryRuntimeBeanReferences = this.toRuntimeBeanReferences(registryConfigBeanNames = service.registry())).isEmpty()) {
            builder.addPropertyValue("registries", registryRuntimeBeanReferences);
        }
        String[] protocolConfigBeanNames = service.protocol();
        ManagedList<RuntimeBeanReference> protocolRuntimeBeanReferences = this.toRuntimeBeanReferences(protocolConfigBeanNames);
        if (!registryRuntimeBeanReferences.isEmpty()) {
            builder.addPropertyValue("protocols", protocolRuntimeBeanReferences);
        }
        return builder.getBeanDefinition();
    }

    private Class<?> resolveServiceInterfaceClass(Class<?> annotatedServiceBeanClass, Service service) {
        Class interfaceClass = service.interfaceClass();
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = service.interfaceName();
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)this.classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)this.classLoader);
            }
        }
        if (interfaceClass == null) {
            return null;
        }
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The type that was annotated @Service is not an interface!");
        return interfaceClass;
    }

    private Class<?> resolveClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveClass(beanDefinition);
    }

    private Class<?> resolveClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader);
    }

    private String[] trims(String annotationPackage) {
        String[] tmpes = Constants.COMMA_SPLIT_PATTERN.split(annotationPackage);
        ArrayList<String> packages = new ArrayList<String>();
        for (String tmpe : tmpes) {
            if ((tmpe = tmpe.trim()).isEmpty()) continue;
            packages.add(tmpe);
        }
        return packages.toArray(new String[0]);
    }

    protected boolean isMatchPackage(Object bean) {
        if (this.annotationPackages.length == 0) {
            return true;
        }
        String beanClassName = this.getOriginalClass(bean).getName();
        for (String pkg : this.annotationPackages) {
            if (!beanClassName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private Class<?> getOriginalClass(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            return AopUtils.getTargetClass((Object)bean);
        }
        return bean.getClass();
    }

    public void destroy() throws Exception {
        this.logger.info("dubbo\u5f00\u59cb\u5173\u95ed....");
        ProtocolConfig.destroyAll();
        RegistryConfig.destroyAll();
    }
}

