/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.TemplateBindException;
import com.fizzed.rocker.runtime.RockerRuntime;
import java.lang.reflect.Field;

public class Rocker {
    public static BindableRockerModel template(String templatePath) {
        RockerModel model = RockerRuntime.getInstance().getBootstrap().model(templatePath);
        return new BindableRockerModel(templatePath, model.getClass().getCanonicalName(), model);
    }

    public static BindableRockerModel template(String templatePath, Object ... arguments) {
        RockerModel model = RockerRuntime.getInstance().getBootstrap().model(templatePath);
        BindableRockerModel bindableModel = new BindableRockerModel(templatePath, model.getClass().getCanonicalName(), model);
        if (arguments != null && arguments.length > 0) {
            String[] argumentNames = Rocker.getModelArgumentNames(templatePath, model);
            if (arguments.length != argumentNames.length) {
                throw new TemplateBindException(templatePath, model.getClass().getCanonicalName(), "Template requires " + argumentNames.length + " arguments but " + arguments.length + " provided");
            }
            for (int i = 0; i < arguments.length; ++i) {
                String name = argumentNames[i];
                Object value = arguments[i];
                bindableModel.bind(name, value);
            }
        }
        return bindableModel;
    }

    private static String[] getModelArgumentNames(String templatePath, RockerModel model) {
        try {
            Field f = model.getClass().getField("ARGUMENT_NAMES");
            return (String[])f.get(null);
        }
        catch (Exception e) {
            throw new TemplateBindException(templatePath, model.getClass().getCanonicalName(), "Unable to read ARGUMENT_NAMES static field from template");
        }
    }
}

