/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.hibernate;

import com.fasterxml.jackson.module.hibernate.HibernateAnnotationIntrospector;
import com.fasterxml.jackson.module.hibernate.HibernateSerializers;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.Serializers;

public class HibernateModule
extends Module {
    private final String NAME = "HibernateModule";
    private static final Version VERSION = new Version(0, 1, 0, null);
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int _moduleFeatures = DEFAULT_FEATURES;

    public String getModuleName() {
        return "HibernateModule";
    }

    public Version version() {
        return VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        AnnotationIntrospector ai = this.annotationIntrospector();
        if (ai != null) {
            context.appendAnnotationIntrospector(ai);
        }
        context.addSerializers((Serializers)new HibernateSerializers(this._moduleFeatures));
    }

    protected AnnotationIntrospector annotationIntrospector() {
        HibernateAnnotationIntrospector ai = new HibernateAnnotationIntrospector();
        ai.setUseTransient(this.isEnabled(Feature.USE_TRANSIENT_ANNOTATION));
        return ai;
    }

    public HibernateModule enable(Feature f) {
        this._moduleFeatures |= f.getMask();
        return this;
    }

    public HibernateModule disable(Feature f) {
        this._moduleFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    public HibernateModule configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        FORCE_LAZY_LOADING(false),
        USE_TRANSIENT_ANNOTATION(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

