/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasioType2MakernoteDescriptor
extends TagDescriptor<CasioType2MakernoteDirectory> {
    public CasioType2MakernoteDescriptor(@NotNull CasioType2MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 2: {
                return this.getThumbnailDimensionsDescription();
            }
            case 3: {
                return this.getThumbnailSizeDescription();
            }
            case 4: {
                return this.getThumbnailOffsetDescription();
            }
            case 8: {
                return this.getQualityModeDescription();
            }
            case 9: {
                return this.getImageSizeDescription();
            }
            case 13: {
                return this.getFocusMode1Description();
            }
            case 20: {
                return this.getIsoSensitivityDescription();
            }
            case 25: {
                return this.getWhiteBalance1Description();
            }
            case 29: {
                return this.getFocalLengthDescription();
            }
            case 31: {
                return this.getSaturationDescription();
            }
            case 32: {
                return this.getContrastDescription();
            }
            case 33: {
                return this.getSharpnessDescription();
            }
            case 3584: {
                return this.getPrintImageMatchingInfoDescription();
            }
            case 8192: {
                return this.getCasioPreviewThumbnailDescription();
            }
            case 8209: {
                return this.getWhiteBalanceBiasDescription();
            }
            case 8210: {
                return this.getWhiteBalance2Description();
            }
            case 8226: {
                return this.getObjectDistanceDescription();
            }
            case 8244: {
                return this.getFlashDistanceDescription();
            }
            case 12288: {
                return this.getRecordModeDescription();
            }
            case 12289: {
                return this.getSelfTimerDescription();
            }
            case 12290: {
                return this.getQualityDescription();
            }
            case 12291: {
                return this.getFocusMode2Description();
            }
            case 12294: {
                return this.getTimeZoneDescription();
            }
            case 12308: {
                return this.getCcdIsoSensitivityDescription();
            }
            case 12309: {
                return this.getColourModeDescription();
            }
            case 12310: {
                return this.getEnhancementDescription();
            }
            case 12311: {
                return this.getFilterDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getFilterDescription() {
        return this.getIndexedDescription(12311, "Off");
    }

    @Nullable
    public String getEnhancementDescription() {
        return this.getIndexedDescription(12310, "Off");
    }

    @Nullable
    public String getColourModeDescription() {
        return this.getIndexedDescription(12309, "Off");
    }

    @Nullable
    public String getCcdIsoSensitivityDescription() {
        return this.getIndexedDescription(12308, "Off", "On");
    }

    @Nullable
    public String getTimeZoneDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(12294);
    }

    @Nullable
    public String getFocusMode2Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12291);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Fixation";
            }
            case 6: {
                return "Multi-Area Focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityDescription() {
        return this.getIndexedDescription(12290, 3, "Fine");
    }

    @Nullable
    public String getSelfTimerDescription() {
        return this.getIndexedDescription(12289, 1, "Off");
    }

    @Nullable
    public String getRecordModeDescription() {
        return this.getIndexedDescription(12288, 2, "Normal");
    }

    @Nullable
    public String getFlashDistanceDescription() {
        return this.getIndexedDescription(8244, "Off");
    }

    @Nullable
    public String getObjectDistanceDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8226);
        if (value == null) {
            return null;
        }
        return Integer.toString(value) + " mm";
    }

    @Nullable
    public String getWhiteBalance2Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8210);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Manual";
            }
            case 1: {
                return "Auto";
            }
            case 4: {
                return "Flash";
            }
            case 12: {
                return "Flash";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceBiasDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(8209);
    }

    @Nullable
    public String getCasioPreviewThumbnailDescription() {
        byte[] bytes = ((CasioType2MakernoteDirectory)this._directory).getByteArray(8192);
        if (bytes == null) {
            return null;
        }
        return "<" + bytes.length + " bytes of image data>";
    }

    @Nullable
    public String getPrintImageMatchingInfoDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(3584);
    }

    @Nullable
    public String getSharpnessDescription() {
        return this.getIndexedDescription(33, "-1", "Normal", "+1");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(32, "-1", "Normal", "+1");
    }

    @Nullable
    public String getSaturationDescription() {
        return this.getIndexedDescription(31, "-1", "Normal", "+1");
    }

    @Nullable
    public String getFocalLengthDescription() {
        Double value = ((CasioType2MakernoteDirectory)this._directory).getDoubleObject(29);
        if (value == null) {
            return null;
        }
        return Double.toString(value / 10.0) + " mm";
    }

    @Nullable
    public String getWhiteBalance1Description() {
        return this.getIndexedDescription(25, "Auto", "Daylight", "Shade", "Tungsten", "Florescent", "Manual");
    }

    @Nullable
    public String getIsoSensitivityDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(20);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 3: {
                return "50";
            }
            case 4: {
                return "64";
            }
            case 6: {
                return "100";
            }
            case 9: {
                return "200";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusMode1Description() {
        return this.getIndexedDescription(13, "Normal", "Macro");
    }

    @Nullable
    public String getImageSizeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(9);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "640 x 480 pixels";
            }
            case 4: {
                return "1600 x 1200 pixels";
            }
            case 5: {
                return "2048 x 1536 pixels";
            }
            case 20: {
                return "2288 x 1712 pixels";
            }
            case 21: {
                return "2592 x 1944 pixels";
            }
            case 22: {
                return "2304 x 1728 pixels";
            }
            case 36: {
                return "3008 x 2008 pixels";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityModeDescription() {
        return this.getIndexedDescription(8, 1, "Fine", "Super Fine");
    }

    @Nullable
    public String getThumbnailOffsetDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(4);
    }

    @Nullable
    public String getThumbnailSizeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        return Integer.toString(value) + " bytes";
    }

    @Nullable
    public String getThumbnailDimensionsDescription() {
        int[] dimensions = ((CasioType2MakernoteDirectory)this._directory).getIntArray(2);
        if (dimensions == null || dimensions.length != 2) {
            return ((CasioType2MakernoteDirectory)this._directory).getString(2);
        }
        return dimensions[0] + " x " + dimensions[1] + " pixels";
    }
}

