/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.applications.datamodeling;

import com.datumbox.framework.common.Configuration;
import com.datumbox.framework.common.dataobjects.Dataframe;
import com.datumbox.framework.common.interfaces.Trainable;
import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConnector;
import com.datumbox.framework.core.machinelearning.common.abstracts.AbstractTrainer;
import com.datumbox.framework.core.machinelearning.common.abstracts.datatransformers.AbstractTransformer;
import com.datumbox.framework.core.machinelearning.common.abstracts.featureselectors.AbstractFeatureSelector;
import com.datumbox.framework.core.machinelearning.common.abstracts.modelers.AbstractModeler;
import com.datumbox.framework.core.machinelearning.common.abstracts.wrappers.AbstractWrapper;
import com.datumbox.framework.core.machinelearning.common.interfaces.ValidationMetrics;

public class Modeler
extends AbstractWrapper<ModelParameters, TrainingParameters> {
    public Modeler(String dbName, Configuration conf) {
        super(dbName, conf, ModelParameters.class, TrainingParameters.class);
    }

    public void predict(Dataframe newData) {
        this.logger.info("predict()");
        this.evaluateData(newData, false);
    }

    public ValidationMetrics validate(Dataframe testData) {
        this.logger.info("validate()");
        return this.evaluateData(testData, true);
    }

    protected void _fit(Dataframe trainingData) {
        Class fsClass;
        boolean selectFeatures;
        boolean transformData;
        TrainingParameters trainingParameters = (TrainingParameters)this.kb().getTrainingParameters();
        Configuration conf = this.kb().getConf();
        Class dtClass = trainingParameters.getDataTransformerClass();
        boolean bl = transformData = dtClass != null;
        if (transformData) {
            this.dataTransformer = (AbstractTransformer)Trainable.newInstance((Class)dtClass, (String)this.dbName, (Configuration)conf);
            this.setParallelized((Trainable)this.dataTransformer);
            this.dataTransformer.fit_transform(trainingData, trainingParameters.getDataTransformerTrainingParameters());
        }
        boolean bl2 = selectFeatures = (fsClass = trainingParameters.getFeatureSelectorClass()) != null;
        if (selectFeatures) {
            this.featureSelector = (AbstractFeatureSelector)Trainable.newInstance((Class)fsClass, (String)this.dbName, (Configuration)conf);
            this.setParallelized((Trainable)this.featureSelector);
            this.featureSelector.fit_transform(trainingData, trainingParameters.getFeatureSelectorTrainingParameters());
        }
        Class mlClass = trainingParameters.getModelerClass();
        this.modeler = (AbstractModeler)Trainable.newInstance((Class)mlClass, (String)this.dbName, (Configuration)conf);
        this.setParallelized((Trainable)this.modeler);
        this.modeler.fit(trainingData, trainingParameters.getModelerTrainingParameters());
        if (transformData) {
            this.dataTransformer.denormalize(trainingData);
        }
    }

    private ValidationMetrics evaluateData(Dataframe data, boolean estimateValidationMetrics) {
        Class fsClass;
        boolean selectFeatures;
        boolean transformData;
        this.kb().load();
        TrainingParameters trainingParameters = (TrainingParameters)this.kb().getTrainingParameters();
        Configuration conf = this.kb().getConf();
        Class dtClass = trainingParameters.getDataTransformerClass();
        boolean bl = transformData = dtClass != null;
        if (transformData) {
            if (this.dataTransformer == null) {
                this.dataTransformer = (AbstractTransformer)Trainable.newInstance((Class)dtClass, (String)this.dbName, (Configuration)conf);
            }
            this.setParallelized((Trainable)this.dataTransformer);
            this.dataTransformer.transform(data);
        }
        boolean bl2 = selectFeatures = (fsClass = trainingParameters.getFeatureSelectorClass()) != null;
        if (selectFeatures) {
            if (this.featureSelector == null) {
                this.featureSelector = (AbstractFeatureSelector)Trainable.newInstance((Class)fsClass, (String)this.dbName, (Configuration)conf);
            }
            this.setParallelized((Trainable)this.featureSelector);
            this.featureSelector.transform(data);
        }
        if (this.modeler == null) {
            Class mlClass = trainingParameters.getModelerClass();
            this.modeler = (AbstractModeler)Trainable.newInstance((Class)mlClass, (String)this.dbName, (Configuration)conf);
        }
        this.setParallelized((Trainable)this.modeler);
        AbstractModeler.AbstractValidationMetrics vm = null;
        if (estimateValidationMetrics) {
            vm = this.modeler.validate(data);
        } else {
            this.modeler.predict(data);
        }
        if (transformData) {
            this.dataTransformer.denormalize(data);
        }
        return vm;
    }

    public static class TrainingParameters
    extends AbstractWrapper.AbstractTrainingParameters<AbstractTransformer, AbstractFeatureSelector, AbstractModeler> {
        private static final long serialVersionUID = 1L;
    }

    public static class ModelParameters
    extends AbstractTrainer.AbstractModelParameters {
        private static final long serialVersionUID = 1L;

        protected ModelParameters(DatabaseConnector dbc) {
            super(dbc);
        }
    }
}

