/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);
    private static final Class<?> DEFAULT_LOADER = ResourceUtil.class;

    private ResourceUtil() {
        throw new AssertionError((Object)("\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316 " + ResourceUtil.class.getName()));
    }

    public static URL getResource(Class<?> loader, String name) {
        URL url = null;
        Class<?> l = loader;
        if (l == null) {
            l = DEFAULT_LOADER;
        }
        if ((url = l.getResource("/" + name)) == null) {
            url = ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static URL getResource(String name) {
        return ResourceUtil.getResource(DEFAULT_LOADER, name);
    }

    public static File getResourceAsFile(Class<?> loader, String name) {
        URL url = ResourceUtil.getResource(loader, name);
        try {
            Path path = Paths.get(url.toURI());
            return path.toFile();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static File getResourceAsFile(String name) {
        return ResourceUtil.getResourceAsFile(DEFAULT_LOADER, name);
    }

    public static InputStream getResourceAsStream(Class<?> loader, String name) {
        URL url = ResourceUtil.getResource(loader, name);
        if (url == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = Files.newInputStream(Paths.get(url.toURI()), new OpenOption[0]);
        }
        catch (IOException ioe) {
            LOG.error(String.join((CharSequence)"", "\u67e5\u627e\u8d44\u6e90\u6587\u4ef6 ", name, " \u53d1\u751f\u9519\u8bef"), (Throwable)ioe);
        }
        catch (URISyntaxException use) {
            LOG.error(String.join((CharSequence)"", "\u67e5\u627e\u8d44\u6e90\u6587\u4ef6 ", name, " \u53d1\u751f\u9519\u8bef"), (Throwable)use);
        }
        return is;
    }

    public static InputStream getResourceAsStream(String name) {
        return ResourceUtil.getResourceAsStream(DEFAULT_LOADER, name);
    }
}

