/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.util;

import com.cpjit.swagger4j.util.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ReflectUtils {
    private ReflectUtils() {
        throw new AssertionError((Object)("\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316 " + ReflectUtils.class.getName()));
    }

    public static List<Class<?>> scanClazzs(List<String> packNames) throws FileNotFoundException, IllegalArgumentException, ClassNotFoundException {
        if (packNames.size() < 1) {
            return Collections.emptyList();
        }
        HashSet clazzs = new HashSet();
        for (String packName : packNames) {
            List<String> clazzNames = ReflectUtils.scanClazzName(packName);
            for (String clazzName : clazzNames) {
                Class<?> clazz = Class.forName(clazzName);
                clazzs.add(clazz);
            }
        }
        if (clazzs.size() < 1) {
            return Collections.emptyList();
        }
        return new ArrayList(clazzs);
    }

    public static List<Class<?>> scanClazzs(List<String> packageNames, boolean recursion) throws FileNotFoundException, IllegalArgumentException, ClassNotFoundException {
        if (packageNames.size() < 1) {
            return Collections.emptyList();
        }
        List<String> packNames = ReflectUtils.scanPackages(packageNames, recursion).stream().map(pkg -> pkg.getName()).collect(Collectors.toList());
        return ReflectUtils.scanClazzs(packNames);
    }

    public static List<Package> scanPackage(String basePackage, boolean recursion) {
        if (StringUtils.isBlank((CharSequence)basePackage)) {
            return Collections.emptyList();
        }
        HashSet<Package> packages = new HashSet<Package>();
        String pack2path = basePackage.replaceAll("\\.", "/");
        URL url = ResourceUtil.getResource(pack2path);
        if (url == null) {
            return Collections.emptyList();
        }
        Path pkFile = null;
        try {
            pkFile = Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(basePackage + "\u4e0d\u662f\u5408\u6cd5\u7684\u5305\u540d", e);
        }
        if (!Files.isDirectory(pkFile, new LinkOption[0])) {
            throw new IllegalArgumentException(basePackage + "\u4e0d\u662f\u5408\u6cd5\u7684\u5305\u540d");
        }
        Package pk = null;
        try {
            pk = ReflectUtils.getPackage(basePackage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pk != null) {
            packages.add(pk);
        }
        if (recursion && StringUtils.isNotBlank((CharSequence)basePackage)) {
            try (DirectoryStream<Path> childs = Files.newDirectoryStream(pkFile);){
                childs.forEach(child -> {
                    if (Files.isDirectory(child, new LinkOption[0])) {
                        String childPackage = basePackage + "." + child.getFileName().toString();
                        if (StringUtils.isBlank((CharSequence)basePackage)) {
                            childPackage = child.getFileName().toString();
                        }
                        packages.addAll(ReflectUtils.scanPackage(childPackage, true));
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (packages.size() < 1) {
            return Collections.emptyList();
        }
        return new ArrayList<Package>(packages);
    }

    public static List<Package> scanPackage(String packageName) {
        return ReflectUtils.scanPackage(packageName, false);
    }

    public static List<Package> scanPackages(List<String> packageNames) {
        return ReflectUtils.scanPackages(packageNames, false);
    }

    public static List<Package> scanPackages(List<String> packageNames, boolean recursion) {
        if (packageNames == null || packageNames.size() < 1) {
            return Collections.emptyList();
        }
        return packageNames.stream().flatMap(packName -> ReflectUtils.scanPackage(packName, recursion).stream()).collect(Collectors.toList());
    }

    public static List<String> scanClazzName(String packageName) throws FileNotFoundException, IllegalArgumentException {
        Path pack;
        URL fullPath;
        String pack2path = packageName.replaceAll("\\.", "/");
        if (StringUtils.isBlank((CharSequence)packageName)) {
            pack2path = "";
        }
        if ((fullPath = ResourceUtil.getResource(pack2path)) == null) {
            throw new FileNotFoundException("\u5305[" + packageName + "]\u4e0d\u5b58\u5728");
        }
        try {
            pack = Paths.get(fullPath.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (!Files.isDirectory(pack, new LinkOption[0])) {
            throw new IllegalArgumentException("[" + packageName + "]\u4e0d\u662f\u5408\u6cd5\u7684\u5305\u540d");
        }
        HashSet clazzNames = new HashSet();
        String prefix = StringUtils.isBlank((CharSequence)packageName) ? "" : packageName + ".";
        try (DirectoryStream<Path> clazzs = Files.newDirectoryStream(pack, "*.class");){
            clazzs.forEach(clazz -> {
                String clazzName = prefix + clazz.getFileName().toString().replace(".class", "");
                clazzNames.add(clazzName);
            });
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (clazzNames.size() < 1) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(clazzNames);
    }

    private static Package getPackage(String packageName) throws FileNotFoundException, IllegalArgumentException {
        Package pkg = Package.getPackage(packageName);
        if (pkg == null) {
            pkg = ReflectUtils.scanClazzName(packageName).stream().map(clazzName -> {
                try {
                    return Class.forName(clazzName).getPackage();
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).filter(pk -> pk != null).findFirst().get();
        }
        return pkg;
    }
}

