/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.support.struts2;

import com.cpjit.swagger4j.support.Constants;
import com.cpjit.swagger4j.support.internal.ApiViewWriter;
import com.cpjit.swagger4j.support.internal.Struts2ApiViewWriter;
import com.cpjit.swagger4j.util.ResourceUtil;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ApiAction
extends ActionSupport
implements Constants {
    @Inject(value="struts.action.extension")
    private String actionExtension;
    @Inject(value="struts.devMode")
    private String devMode;
    private ApiViewWriter apiViewWriter = new Struts2ApiViewWriter();
    private String url;

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        Properties props = this.loadSettings(request);
        this.apiViewWriter.writeApis(request, ServletActionContext.getResponse(), props);
        return null;
    }

    @Deprecated
    public void toIndex() throws Exception {
        this.index();
    }

    public void index() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        String lang = request.getParameter("lang");
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = "zh-cn";
        }
        Properties props = this.loadSettings(request);
        this.apiViewWriter.writeIndex(request, ServletActionContext.getResponse(), lang, props);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void statics() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.apiViewWriter.writeStatic(request, response, this.loadSettings(request));
    }

    private Properties loadSettings(HttpServletRequest request) throws IOException {
        String suffix;
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream("swagger.properties");
        props.load(is);
        String path = request.getContextPath();
        String host = request.getServerName() + ":" + request.getServerPort() + path;
        props.setProperty("apiHost", host);
        String apiFile = props.getProperty("apiFile");
        if (StringUtils.isBlank((CharSequence)apiFile)) {
            apiFile = "/WEB-INF/apis.json";
        }
        String apiFilePath = request.getServletContext().getRealPath(apiFile);
        props.setProperty("apiFile", apiFilePath);
        if (StringUtils.isBlank((CharSequence)props.getProperty("devMode"))) {
            props.setProperty("devMode", this.devMode);
        }
        if (StringUtils.isBlank((CharSequence)(suffix = props.getProperty("suffix")))) {
            suffix = "";
        }
        props.put("suffix", suffix);
        return props;
    }
}

