/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.support.springmvc;

import com.cpjit.swagger4j.annotation.API;
import com.cpjit.swagger4j.annotation.APIs;
import com.cpjit.swagger4j.annotation.Param;
import com.cpjit.swagger4j.support.Constants;
import com.cpjit.swagger4j.support.internal.ApiViewWriter;
import com.cpjit.swagger4j.support.internal.DefaultApiViewWriter;
import com.cpjit.swagger4j.util.ResourceUtil;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api"})
@APIs(value="/api")
public class ApiController
implements InitializingBean,
Constants {
    private ApiViewWriter apiViewWriter = new DefaultApiViewWriter();
    private Properties props = new Properties();

    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    @API(value="", summary="\u83b7\u53d6API\u6587\u6863", method="get", parameters={@Param(name="lang", description="\u8bed\u8a00\uff08\u9ed8\u8ba4\u4e3a\u4e2d\u6587\uff09", type="string", format="string")})
    public void index(HttpServletRequest request, HttpServletResponse response, @RequestParam(defaultValue="zh-cn") String lang) throws Exception {
        String suffix;
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = "zh-cn";
        }
        if (StringUtils.isBlank((CharSequence)(suffix = this.props.getProperty("suffix")))) {
            suffix = "";
        }
        this.props.put("suffix", suffix);
        this.apiViewWriter.writeIndex(request, response, lang, this.props);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public void queryApi(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream("swagger.properties");
        props.load(is);
        String path = request.getContextPath();
        String host = request.getServerName() + ":" + request.getServerPort() + path;
        props.setProperty("apiHost", host);
        String apiFile = props.getProperty("apiFile");
        if (StringUtils.isBlank((CharSequence)apiFile)) {
            apiFile = "/WEB-INF/apis.json";
        }
        String apiFilePath = request.getServletContext().getRealPath(apiFile);
        props.setProperty("apiFile", apiFilePath);
        this.apiViewWriter.writeApis(request, response, props);
    }

    @RequestMapping(value={"statics/**"}, method={RequestMethod.GET})
    public void queryStatic(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.apiViewWriter.writeStatic(request, response, this.props);
    }

    public void afterPropertiesSet() throws Exception {
        InputStream is = ResourceUtil.getResourceAsStream("swagger.properties");
        this.props.load(is);
    }
}

