/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.support.servlet;

import com.cpjit.swagger4j.support.Constants;
import com.cpjit.swagger4j.support.internal.ApiViewWriter;
import com.cpjit.swagger4j.support.internal.DefaultApiViewWriter;
import com.cpjit.swagger4j.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ApiServlet
extends HttpServlet
implements Constants {
    private ApiViewWriter apiViewWriter = new DefaultApiViewWriter();
    private Properties props = new Properties();

    public void init() throws ServletException {
        InputStream is = ResourceUtil.getResourceAsStream("swagger.properties");
        try {
            this.props.load(is);
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.matches(".*/api/index(/?)(!/)*")) {
            this.toIndex(req, resp);
        } else if (uri.matches(".*/api/statics/.+")) {
            this.queryStatic(req, resp);
        } else {
            try {
                this.queryApi(req, resp);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void toIndex(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String suffix;
        String lang = request.getParameter("lang");
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = "zh-cn";
        }
        if (StringUtils.isBlank((CharSequence)(suffix = this.props.getProperty("suffix")))) {
            suffix = "";
        }
        this.props.put("suffix", suffix);
        this.apiViewWriter.writeIndex(request, response, lang, this.props);
    }

    private void queryStatic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.apiViewWriter.writeStatic(request, response, this.props);
    }

    private void queryApi(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream("swagger.properties");
        props.load(is);
        String path = request.getContextPath();
        String host = request.getServerName() + ":" + request.getServerPort() + path;
        props.setProperty("apiHost", host);
        String apiFile = props.getProperty("apiFile");
        if (StringUtils.isBlank((CharSequence)apiFile)) {
            apiFile = "/WEB-INF/apis.json";
        }
        String apiFilePath = request.getServletContext().getRealPath(apiFile);
        props.setProperty("apiFile", apiFilePath);
        this.apiViewWriter.writeApis(request, response, props);
    }
}

