/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j.support.internal;

import com.alibaba.fastjson.JSONWriter;
import com.cpjit.swagger4j.APIParser;
import com.cpjit.swagger4j.support.internal.ApiViewWriter;
import com.cpjit.swagger4j.support.internal.FileTypeMap;
import com.cpjit.swagger4j.support.internal.templates.FreemarkerUtils;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiViewWriter
implements ApiViewWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApiViewWriter.class);
    private static boolean scanfed = false;

    protected String getTemplateName() {
        return "api.ftlh";
    }

    @Override
    public void writeIndex(HttpServletRequest request, HttpServletResponse response, String lang, Properties props) throws IOException {
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("lang", lang);
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        root.put("basePath", basePath);
        String host = request.getServerName() + ":" + request.getServerPort() + path;
        String suffix = props.getProperty("suffix");
        if (StringUtils.isBlank((CharSequence)suffix)) {
            suffix = "";
        }
        root.put("getApisUrl", "http://" + host + "/api" + suffix);
        root.put("apiDescription", props.getProperty("apiDescription"));
        root.put("apiTitle", props.getProperty("apiTitle"));
        root.put("apiVersion", props.getProperty("apiVersion"));
        root.put("suffix", suffix);
        Template template = FreemarkerUtils.getTemplate(this.getTemplateName());
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = response.getWriter();
        try {
            template.process(root, (Writer)out);
        }
        catch (TemplateException e) {
            throw new IOException(e);
        }
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    @Override
    public void writeApis(HttpServletRequest request, HttpServletResponse response, Properties props) throws Exception {
        APIParser restParser = APIParser.newInstance(props);
        response.setContentType("application/json;charset=utf-8");
        String devMode = props.getProperty("devMode");
        if (Boolean.valueOf(devMode).booleanValue()) {
            Object apis = restParser.parseAndNotStore();
            JSONWriter writer = new JSONWriter((Writer)response.getWriter());
            writer.writeObject(apis);
            writer.flush();
            writer.close();
        } else {
            if (!scanfed) {
                restParser.parse();
                scanfed = true;
            }
            byte[] bs = Files.readAllBytes(Paths.get(props.getProperty("apiFile"), new String[0]));
            ServletOutputStream out = response.getOutputStream();
            out.write(bs);
            out.flush();
            out.close();
        }
    }

    protected String buildResourcePath(HttpServletRequest request, Properties config) {
        int index;
        String uri = request.getRequestURI();
        String suffix = (String)config.get("suffix");
        if (suffix != null && (index = uri.lastIndexOf(suffix)) > 0) {
            uri = uri.substring(0, index);
        }
        String path = uri.substring(uri.indexOf("statics") + 7);
        path = "com/cpjit/swagger4j/support/internal/statics" + path;
        return path;
    }

    @Deprecated
    protected String buildResourcePath(HttpServletRequest request) {
        return this.buildResourcePath(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStatic(HttpServletRequest request, HttpServletResponse response, Properties props) throws IOException {
        String path = this.buildResourcePath(request, props);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.join((CharSequence)"", "\u83b7\u53d6web\u8d44\u6e90\u6587\u4ef6\uff1a ", path));
        }
        String contentType = FileTypeMap.getContentType(path);
        response.setContentType(contentType);
        InputStream resource = DefaultApiViewWriter.class.getClassLoader().getResourceAsStream(path);
        if (resource == null) {
            response.sendError(404);
            return;
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            byte[] buff = new byte[512];
            int len = -1;
            while ((len = resource.read(buff)) != -1) {
                out.write(buff, 0, len);
            }
            out.flush();
        }
        finally {
            try {
                if (resource != null) {
                    resource.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @Deprecated
    public void writeStatic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeStatic(request, response, null);
    }
}

