/*
 * Decompiled with CFR 0.152.
 */
package com.cpjit.swagger4j;

import com.alibaba.fastjson.JSONWriter;
import com.cpjit.swagger4j.APIDoc;
import com.cpjit.swagger4j.APIDocInfo;
import com.cpjit.swagger4j.APIParseable;
import com.cpjit.swagger4j.License;
import com.cpjit.swagger4j.Path;
import com.cpjit.swagger4j.Tag;
import com.cpjit.swagger4j.annotation.API;
import com.cpjit.swagger4j.annotation.APISchema;
import com.cpjit.swagger4j.annotation.APISchemaPropertie;
import com.cpjit.swagger4j.annotation.APISchemas;
import com.cpjit.swagger4j.annotation.APITag;
import com.cpjit.swagger4j.annotation.APITags;
import com.cpjit.swagger4j.annotation.APIs;
import com.cpjit.swagger4j.annotation.DataType;
import com.cpjit.swagger4j.annotation.Item;
import com.cpjit.swagger4j.annotation.Items;
import com.cpjit.swagger4j.annotation.Param;
import com.cpjit.swagger4j.util.ReflectUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class APIParser
implements APIParseable {
    private static final Logger LOG = LoggerFactory.getLogger(APIParser.class);
    private static final String DELIMITER = "[;,]";
    private String host;
    private String basePath;
    private String suffix = "";
    private APIDocInfo info;
    private String file;
    private List<String> packageToScan;
    private Map<String, Item> items;
    private List<Package> packages;

    public static final APIParser newInstance(Properties props) throws IOException {
        String[] packageToScan = props.getProperty("packageToScan").split(DELIMITER);
        Builder builder = new Builder(props.getProperty("apiHost"), props.getProperty("apiFile"), packageToScan).basePath(props.getProperty("apiBasePath")).description(props.getProperty("apiDescription")).termsOfService(props.getProperty("termsOfService")).title(props.getProperty("apiTitle")).version(props.getProperty("apiVersion")).suffix(props.getProperty("suffix"));
        return new APIParser(builder);
    }

    private APIParser(Builder builder) {
        this.host = builder.host;
        this.file = builder.file;
        this.packageToScan = builder.packageToScan;
        try {
            this.packages = ReflectUtils.scanPackages(this.packageToScan, true);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u626b\u63cf\u5305\u4fe1\u606f\u5931\u8d25", e);
        }
        this.basePath = builder.basePath;
        this.suffix = builder.suffix;
        this.info = new APIDocInfo.Builder().contact(builder.contact).description(builder.description).license(builder.license).termsOfService(builder.termsOfService).title(builder.title).version(builder.version).build();
    }

    public String getFile() {
        return this.file;
    }

    public List<String> getPackageToScan() {
        return this.packageToScan;
    }

    @Override
    public void parse() throws Exception {
        File f = new File(this.file);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.join((CharSequence)"", "\u751f\u6210\u7684\u6587\u4ef6\u4fdd\u5b58\u5728=>", f.getAbsolutePath()));
        }
        JSONWriter writer = new JSONWriter((Writer)new FileWriter(f));
        APIDoc api = (APIDoc)this.parseAndNotStore();
        writer.writeObject((Object)api);
        writer.flush();
        writer.close();
    }

    @Override
    public Object parseAndNotStore() throws Exception {
        APIDoc api = new APIDoc();
        String[] schemes = new String[]{"http"};
        api.setSchemes(schemes);
        api.setHost(this.host);
        api.setBasePath(this.basePath);
        api.setInfo(this.info);
        this.items = this.parseItem();
        Collection<Tag> tags = this.parseTag();
        api.setTags(tags);
        Map<String, Map<String, Path>> paths = this.parsePath();
        api.setPaths(paths);
        Map<String, Object> definitions = this.parseDefinition();
        api.setDefinitions(definitions);
        return api;
    }

    private Map<String, Item> parseItem() throws Exception {
        return this.packages.stream().filter(pk -> pk.getAnnotation(Items.class) != null).map(pk -> pk.getAnnotation(Items.class)).flatMap(items -> Arrays.stream(items.items())).collect(Collectors.toMap(item -> item.value(), item -> item));
    }

    private Map<String, Map<String, Path>> parsePath() throws Exception {
        HashMap<String, Map<String, Path>> paths = new HashMap<String, Map<String, Path>>();
        ReflectUtils.scanClazzs(this.packageToScan, true).stream().forEach(clazz -> {
            APIs apis = clazz.getAnnotation(APIs.class);
            if (apis == null || apis.hide()) {
                return;
            }
            this.scanAPIMethod((Class<?>)clazz).stream().forEach(method -> this.api2Path((Method)method, apis, paths));
        });
        return paths;
    }

    private void api2Path(Method method, APIs apis, Map<String, Map<String, Path>> paths) {
        Path p;
        API service = method.getAnnotation(API.class);
        if (service.hide()) {
            return;
        }
        boolean isMultipart = this.hasMultipart(service);
        String url = "".equals(service.value()) ? String.join((CharSequence)"", apis.value(), this.suffix) : String.join((CharSequence)"", apis.value(), "/", service.value(), this.suffix);
        Map<String, Path> path = paths.get(url);
        if (path == null) {
            path = new HashMap<String, Path>();
            paths.put(url, path);
        }
        if ((p = path.get(service.method())) == null) {
            p = new Path();
            path.put(service.method().toLowerCase(), p);
        }
        if (StringUtils.isNotBlank((CharSequence)service.description())) {
            p.setDescription(service.description());
        } else {
            p.setDescription(service.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)service.operationId())) {
            p.setOperationId(service.operationId());
        } else {
            p.setOperationId(method.getName());
        }
        List<String> tags = Arrays.asList(service.tags());
        if (service.tags().length == 0) {
            String ns = apis.value();
            if (ns.startsWith("/")) {
                ns = ns.substring(1);
            }
            tags = Arrays.asList(ns);
        }
        p.setTags(tags);
        p.setSummary(service.summary());
        if (isMultipart) {
            p.setConsumes(Arrays.asList("multipart/form-data"));
        } else {
            p.setConsumes(Arrays.asList(service.consumes()));
        }
        p.setProduces(Arrays.asList(service.produces()));
        p.setDeprecated(service.deprecated());
        p.setParameters(this.parseParameters(service, isMultipart));
    }

    private List<Map<String, Object>> parseParameters(API service, boolean isMultipart) {
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        for (Param paramAttr : service.parameters()) {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            if (paramAttr.schema() != null && !paramAttr.schema().trim().equals("")) {
                if (isMultipart) {
                    throw new IllegalArgumentException(String.join((CharSequence)"", "\u8bf7\u6c42\u7684Content-Type\u4e3amultipart/form-data\uff0c\u5c06\u5ffd\u7565\u590d\u6742\u7c7b\u578b\u7684\u8bf7\u6c42\u53c2\u6570[ ", paramAttr.schema(), " ]"));
                }
                parameter.put("in", "body");
                parameter.put("name", "body");
                HashMap<String, String> ref = new HashMap<String, String>();
                ref.put("$ref", "#/definitions/" + paramAttr.schema());
                parameter.put("schema", ref);
            } else {
                String requestParamFormat;
                String requestParamType;
                if (paramAttr.dataType() != DataType.UNKNOWN) {
                    requestParamType = paramAttr.dataType().type();
                    requestParamFormat = paramAttr.dataType().format();
                } else {
                    requestParamType = paramAttr.type();
                    requestParamFormat = paramAttr.format();
                }
                if (isMultipart && !"path".equals(paramAttr.in()) && !"header".equals(paramAttr.in())) {
                    parameter.put("in", "formData");
                    parameter.put("type", requestParamType);
                } else {
                    String in = paramAttr.in();
                    if (StringUtils.isBlank((CharSequence)in)) {
                        in = "post".equalsIgnoreCase(service.method()) ? "formData" : "query";
                    }
                    parameter.put("in", in);
                    parameter.put("type", requestParamType);
                    if (StringUtils.isNotBlank((CharSequence)requestParamFormat)) {
                        parameter.put("format", requestParamFormat);
                    }
                }
                parameter.put("name", paramAttr.name());
                parameter.put("description", paramAttr.description());
                parameter.put("required", paramAttr.required());
                if (paramAttr.items() != null && !paramAttr.items().trim().equals("")) {
                    if (!requestParamType.equals("array")) {
                        throw new IllegalArgumentException(String.join((CharSequence)"", "\u8bf7\u6c42\u53c2\u6570 [ ", paramAttr.name(), " ]\u5b58\u5728\u53ef\u9009\u503c(items)\u7684\u65f6\u5019\uff0c\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b(type)\u7684\u503c\u53ea\u80fd\u4e3aarray"));
                    }
                    Item item = this.items.get(paramAttr.items().trim());
                    if (item != null) {
                        HashMap<String, Object> i = new HashMap<String, Object>();
                        i.put("type", item.type());
                        i.put("default", item.defaultValue());
                        i.put("enum", this.parseOptionalValue(item.type(), item.optionalValue()));
                        parameter.put("items", i);
                    }
                }
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    private Object parseOptionalValue(String type, String[] values) {
        if (type.equals("string")) {
            return values;
        }
        if (type.equals("boolean")) {
            return Arrays.stream(values).map(s -> Boolean.parseBoolean(s)).collect(Collectors.toList());
        }
        if (type.equals("integer")) {
            return Arrays.stream(values).mapToInt(s -> Integer.parseInt(s)).toArray();
        }
        return Arrays.stream(values).mapToDouble(s -> Double.parseDouble(s)).toArray();
    }

    private boolean hasMultipart(API service) {
        return Arrays.stream(service.consumes()).filter(consume -> "multipart/form-data".equals(consume)).findFirst().isPresent();
    }

    private Collection<Tag> parseTag() throws Exception {
        Stream tagsFromClass = this.scanAPIsAnnotations().stream();
        Stream tagsFromPackage = this.packages.stream().map(pk -> pk.getAnnotation(APITags.class)).filter(apiTags -> apiTags != null).flatMap(apiTags -> Arrays.stream(apiTags.tags()));
        return Stream.of(tagsFromClass, tagsFromPackage).flatMap(stream -> stream).map(apiTag -> new Tag(apiTag.value(), apiTag.description())).collect(Collectors.toSet());
    }

    private Map<String, Object> parseDefinition() throws Exception {
        HashMap<String, Object> definitions = new HashMap<String, Object>();
        for (Package pk : this.packages) {
            APISchema[] schemas;
            APISchemas apiSchemas = pk.getAnnotation(APISchemas.class);
            if (apiSchemas == null) continue;
            for (APISchema schema : schemas = apiSchemas.schemas()) {
                HashMap<String, Object> definition = new HashMap<String, Object>();
                definition.put("type", schema.type());
                ArrayList<String> required = new ArrayList<String>();
                definition.put("required", required);
                APISchemaPropertie[] props = schema.properties();
                HashMap properties = new HashMap();
                for (APISchemaPropertie prop : props) {
                    HashMap<String, Object> propertie = new HashMap<String, Object>();
                    definition.put("properties", properties);
                    propertie.put("type", prop.type());
                    propertie.put("format", prop.format());
                    propertie.put("description", prop.description());
                    if (prop.required()) {
                        required.add(prop.value());
                    }
                    if (prop.optionalValue().length > 0) {
                        propertie.put("enum", this.parseOptionalValue(prop.type(), prop.optionalValue()));
                    }
                    properties.put(prop.value(), propertie);
                }
                definitions.put(schema.value(), definition);
            }
        }
        return definitions;
    }

    private List<Method> scanAPIMethod(Class<?> clazz) {
        APIs apis = clazz.getAnnotation(APIs.class);
        if (apis == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getAnnotation(API.class) != null).collect(Collectors.toList());
    }

    private List<APITag> scanAPIsAnnotations() throws Exception {
        return ReflectUtils.scanClazzs(this.packageToScan, true).stream().map(clazz -> clazz.getAnnotation(APITag.class)).filter(apiTag -> apiTag != null).collect(Collectors.toList());
    }

    public static class Builder {
        private String host;
        private String file;
        private List<String> packageToScan;
        private String basePath;
        private String suffix = "";
        private String description;
        private String version;
        private String title;
        private String termsOfService;
        private String contact;
        private License license;

        public Builder(String host, String file, String[] packageToScan) {
            this(host, file, Arrays.asList(packageToScan));
        }

        public Builder(String host, String file, List<String> packageToScan) {
            this.host = host;
            this.file = file;
            this.packageToScan = packageToScan;
        }

        public APIParser build() {
            return new APIParser(this);
        }

        public Builder basePath(String val) {
            this.basePath = val;
            return this;
        }

        public Builder suffix(String suffix) {
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                this.suffix = suffix;
            }
            return this;
        }

        public Builder description(String val) {
            this.description = val;
            return this;
        }

        public Builder version(String val) {
            this.version = val;
            return this;
        }

        public Builder title(String val) {
            this.title = val;
            return this;
        }

        public Builder termsOfService(String val) {
            this.termsOfService = val;
            return this;
        }

        public Builder contact(String val) {
            this.contact = val;
            return this;
        }

        public Builder license(License val) {
            this.license = val;
            return this;
        }
    }
}

