/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.messages.XHRSendPacketsMessage;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.MainBaseClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.UUID;

public class XHRPollingClient
extends MainBaseClient {
    public static final AttributeKey<Boolean> WRITE_ONCE = AttributeKey.valueOf((String)"writeOnce");
    private final Queue<Packet> packetQueue = PlatformDependent.newMpscQueue();
    private String origin;

    public XHRPollingClient(AckManager ackManager, DisconnectableHub disconnectable, UUID sessionId, Transport transport, StoreFactory storeFactory, HandshakeData handshakeData) {
        super(sessionId, ackManager, disconnectable, transport, storeFactory, handshakeData);
    }

    public void bindChannel(Channel channel, String origin) {
        this.origin = origin;
        this.setChannel(channel);
        channel.writeAndFlush((Object)new XHRSendPacketsMessage(this.getSessionId(), origin, this.packetQueue));
    }

    public String getOrigin() {
        return this.origin;
    }

    public ChannelFuture send(Packet packet) {
        this.packetQueue.add(packet);
        if (this.getChannel().attr(WRITE_ONCE).get() == null) {
            return this.getChannel().writeAndFlush((Object)new XHRSendPacketsMessage(this.getSessionId(), this.origin, this.packetQueue));
        }
        return this.getChannel().newSucceededFuture();
    }
}

