/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.transport;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.parser.Packet;
import com.corundumstudio.socketio.parser.PacketType;
import com.corundumstudio.socketio.transport.MainBaseClient;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class NamespaceClient
implements SocketIOClient {
    private final AtomicBoolean disconnected = new AtomicBoolean();
    private final MainBaseClient baseClient;
    private final Namespace namespace;

    public NamespaceClient(MainBaseClient baseClient, Namespace namespace) {
        this.baseClient = baseClient;
        this.namespace = namespace;
        namespace.addClient(this);
    }

    public MainBaseClient getBaseClient() {
        return this.baseClient;
    }

    @Override
    public Transport getTransport() {
        return this.baseClient.getTransport();
    }

    @Override
    public boolean isChannelOpen() {
        return this.baseClient.getChannel().isOpen();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void sendEvent(String name, Object ... data) {
        Packet packet = new Packet(PacketType.EVENT);
        packet.setName(name);
        packet.setArgs(Arrays.asList(data));
        this.send(packet);
    }

    @Override
    public void sendEvent(String name, AckCallback<?> ackCallback, Object ... data) {
        Packet packet = new Packet(PacketType.EVENT);
        packet.setName(name);
        packet.setArgs(Arrays.asList(data));
        this.send(packet, ackCallback);
    }

    @Override
    public void sendMessage(String message, AckCallback<?> ackCallback) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setData(message);
        this.send(packet, ackCallback);
    }

    @Override
    public void sendMessage(String message) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setData(message);
        this.send(packet);
    }

    @Override
    public void sendJsonObject(Object object) {
        Packet packet = new Packet(PacketType.JSON);
        packet.setData(object);
        this.send(packet);
    }

    private boolean isConnected() {
        return !this.disconnected.get() && this.baseClient.isConnected();
    }

    @Override
    public void send(Packet packet, AckCallback<?> ackCallback) {
        if (!this.isConnected()) {
            ackCallback.onTimeout();
            return;
        }
        long index = this.baseClient.getAckManager().registerAck(this.getSessionId(), ackCallback);
        packet.setId(index);
        if (!ackCallback.getResultClass().equals(Void.class)) {
            packet.setAck("data");
        }
        this.send(packet);
    }

    @Override
    public void send(Packet packet) {
        if (!this.isConnected()) {
            return;
        }
        packet.setEndpoint(this.namespace.getName());
        this.baseClient.send(packet);
    }

    @Override
    public void sendJsonObject(Object object, AckCallback<?> ackCallback) {
        Packet packet = new Packet(PacketType.JSON);
        packet.setData(object);
        this.send(packet, ackCallback);
    }

    public void onDisconnect() {
        this.disconnected.set(true);
        this.baseClient.removeChildClient(this);
        this.namespace.onDisconnect(this);
    }

    @Override
    public void disconnect() {
        this.send(new Packet(PacketType.DISCONNECT));
        this.onDisconnect();
    }

    @Override
    public UUID getSessionId() {
        return this.baseClient.getSessionId();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.baseClient.getRemoteAddress();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        result = 31 * result + (this.getNamespace().getName() == null ? 0 : this.getNamespace().getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceClient other = (NamespaceClient)obj;
        if (this.getSessionId() == null ? other.getSessionId() != null : !this.getSessionId().equals(other.getSessionId())) {
            return false;
        }
        return !(this.getNamespace().getName() == null ? other.getNamespace().getName() != null : !this.getNamespace().getName().equals(other.getNamespace().getName()));
    }

    @Override
    public void joinRoom(String room) {
        this.namespace.joinRoom(room, this.getSessionId());
    }

    @Override
    public void leaveRoom(String room) {
        this.namespace.leaveRoom(room, this.getSessionId());
    }

    @Override
    public void set(String key, String val) {
        this.baseClient.getStore().set(key, val);
    }

    @Override
    public String get(String key) {
        return this.baseClient.getStore().get(key);
    }

    @Override
    public boolean has(String key) {
        return this.baseClient.getStore().has(key);
    }

    @Override
    public void del(String key) {
        this.baseClient.getStore().del(key);
    }

    @Override
    public Set<String> getAllRooms() {
        return this.namespace.getRooms(this);
    }

    @Override
    public HandshakeData getHandshakeData() {
        return this.baseClient.getHandshakeData();
    }
}

