/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.MultiTypeArgs;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnEvent;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.MultiTypeEventListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OnEventScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnEvent.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, final Method method, Annotation annot) {
        OnEvent annotation = (OnEvent)annot;
        if (annotation.value() == null || annotation.value().trim().length() == 0) {
            throw new IllegalArgumentException("OnEvent \"value\" parameter is required");
        }
        final int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        final int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        final List<Integer> dataIndexes = this.dataIndexes(method);
        if (dataIndexes.size() > 1) {
            ArrayList classes = new ArrayList();
            for (int index : dataIndexes) {
                Class<?> param = method.getParameterTypes()[index];
                classes.add(param);
            }
            namespace.addMultiTypeEventListener(annotation.value(), new MultiTypeEventListener(){

                @Override
                public void onData(SocketIOClient client, MultiTypeArgs data, AckRequest ackSender) {
                    try {
                        Object[] args = new Object[method.getParameterTypes().length];
                        if (socketIOClientIndex != -1) {
                            args[socketIOClientIndex] = client;
                        }
                        if (ackRequestIndex != -1) {
                            args[ackRequestIndex] = ackSender;
                        }
                        int i = 0;
                        Iterator i$ = dataIndexes.iterator();
                        while (i$.hasNext()) {
                            int index = (Integer)i$.next();
                            args[index] = data.get(i);
                            ++i;
                        }
                        method.invoke(object, args);
                    }
                    catch (InvocationTargetException e) {
                        throw new SocketIOException(e.getCause());
                    }
                    catch (Exception e) {
                        throw new SocketIOException(e);
                    }
                }
            }, classes.toArray(new Class[classes.size()]));
        } else {
            Class objectType = Void.class;
            if (!dataIndexes.isEmpty()) {
                objectType = method.getParameterTypes()[dataIndexes.iterator().next()];
            }
            namespace.addEventListener(annotation.value(), objectType, new DataListener<Object>(){

                @Override
                public void onData(SocketIOClient client, Object data, AckRequest ackSender) {
                    try {
                        Object[] args = new Object[method.getParameterTypes().length];
                        if (socketIOClientIndex != -1) {
                            args[socketIOClientIndex] = client;
                        }
                        if (ackRequestIndex != -1) {
                            args[ackRequestIndex] = ackSender;
                        }
                        if (!dataIndexes.isEmpty()) {
                            int dataIndex = (Integer)dataIndexes.iterator().next();
                            args[dataIndex] = data;
                        }
                        method.invoke(object, args);
                    }
                    catch (InvocationTargetException e) {
                        throw new SocketIOException(e.getCause());
                    }
                    catch (Exception e) {
                        throw new SocketIOException(e);
                    }
                }
            });
        }
    }

    private List<Integer> dataIndexes(Method method) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (!type.equals(AckRequest.class) && !type.equals(SocketIOClient.class)) {
                result.add(index);
            }
            ++index;
        }
        return result;
    }

    private int paramIndex(Method method, Class clazz) {
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (type.equals(clazz)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void validate(Method method, Class clazz) {
        int paramsCount = method.getParameterTypes().length;
        int socketIOClientIndex = this.paramIndex(method, SocketIOClient.class);
        int ackRequestIndex = this.paramIndex(method, AckRequest.class);
        List<Integer> dataIndexes = this.dataIndexes(method);
        paramsCount -= dataIndexes.size();
        if (socketIOClientIndex != -1) {
            --paramsCount;
        }
        if (ackRequestIndex != -1) {
            --paramsCount;
        }
        if (paramsCount != 0) {
            throw new IllegalArgumentException("Wrong OnEvent listener signature: " + clazz + "." + method.getName());
        }
    }
}

