/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.exception.BladeException;
import com.blade.kit.DateKit;
import com.blade.kit.IOKit;
import com.blade.kit.StringKit;
import com.blade.mvc.Const;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.server.netty.ProgressiveFutureListener;
import com.blade.server.netty.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileHandler
implements RequestHandler<Boolean> {
    public static final Logger log = LoggerFactory.getLogger(StaticFileHandler.class);
    private boolean showFileList;
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[^-\\._]?[^<>&\\\"]*");
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");

    public StaticFileHandler(Blade blade) {
        this.showFileList = blade.environment().getBoolean("mvc.statics.show-list", false);
    }

    @Override
    public Boolean handle(ChannelHandlerContext ctx, Request request, Response response) throws BladeException {
        RandomAccessFile raf;
        if (!"GET".equals(request.method())) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return false;
        }
        String uri = request.uri();
        if (uri.startsWith("/webjars/")) {
            InputStream input = StaticFileHandler.class.getResourceAsStream("/META-INF/resources" + uri);
            if (null == input) {
                StaticFileHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            } else {
                if (this.http304(ctx, request, -1L)) {
                    return false;
                }
                String content = null;
                try {
                    content = IOKit.readToString(input);
                }
                catch (IOException e) {
                    throw new BladeException(e);
                }
                DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
                StaticFileHandler.setDateAndCacheHeaders((HttpResponse)httpResponse, null);
                String contentType = StringKit.mimeType(uri);
                if (null != contentType) {
                    httpResponse.headers().set("Content-Type", (Object)contentType);
                }
                httpResponse.headers().set("Content-Length", (Object)content.length());
                if (request.keepAlive()) {
                    httpResponse.headers().set("Connection", (Object)"keep-alive");
                }
                ctx.writeAndFlush((Object)httpResponse);
            }
            return false;
        }
        String path = StaticFileHandler.sanitizeUri(uri);
        if (path == null) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return false;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return false;
        }
        if (file.isDirectory() && this.showFileList) {
            if (uri.endsWith("/")) {
                StaticFileHandler.sendListing(ctx, file, uri);
            } else {
                response.redirect(uri + '/');
            }
            return false;
        }
        if (!file.isFile()) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return false;
        }
        if (this.http304(ctx, request, file.lastModified())) {
            return false;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            StaticFileHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return false;
        }
        try {
            ChannelFuture lastContentFuture;
            ChannelFuture sendFileFuture;
            long fileLength = raf.length();
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileHandler.setContentTypeHeader((HttpResponse)httpResponse, file);
            StaticFileHandler.setDateAndCacheHeaders((HttpResponse)httpResponse, file);
            httpResponse.headers().set("Content-Length", (Object)fileLength);
            if (request.keepAlive()) {
                httpResponse.headers().set("Connection", (Object)"keep-alive");
            }
            ctx.write((Object)httpResponse);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build(raf));
            if (!request.keepAlive()) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            throw new BladeException(e);
        }
        return false;
    }

    private boolean http304(ChannelHandlerContext ctx, Request request, long lastModified) {
        String ifMdf = request.header("If-Modified-Since");
        if (StringKit.isBlank(ifMdf)) {
            return false;
        }
        String ifModifiedSince = ifMdf;
        Date ifModifiedSinceDate = this.format(ifModifiedSince, "EEE, dd MMM yyyy HH:mm:ss zzz");
        long ifModifiedSinceDateSeconds = ifModifiedSinceDate.getTime() / 1000L;
        if (lastModified < 0L && ifModifiedSinceDateSeconds <= Instant.now().getEpochSecond()) {
            StaticFileHandler.sendNotModified(ctx);
            return true;
        }
        long fileLastModifiedSeconds = lastModified / 1000L;
        if (ifModifiedSinceDateSeconds == fileLastModifiedSeconds) {
            StaticFileHandler.sendNotModified(ctx);
            return true;
        }
        return false;
    }

    public Date format(String date, String pattern) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(pattern, Locale.US);
        LocalDateTime formatted = LocalDateTime.parse(date, fmt);
        Instant instant = formatted.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    private static void sendListing(ChannelHandlerContext ctx, File dir, String dirPath) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head><meta charset='utf-8' /><title>").append("\u6587\u4ef6\u5217\u8868: ").append(dirPath).append("</title></head><body>\r\n").append("<h3>\u6587\u4ef6\u5217\u8868: ").append(dirPath).append("</h3>\r\n").append("<ul>").append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : dir.listFiles()) {
            String name;
            if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            buf.append("<li><a href=\"").append(name).append("\">").append(name).append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8);
        response.content().writeBytes(buffer);
        buffer.release();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        StaticFileHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(FullHttpResponse response) {
        response.headers().set("Date", (Object)DateKit.gmtDate());
    }

    private static String sanitizeUri(String uri) {
        if (uri.isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return Const.CLASSPATH + File.separator + uri.substring(1);
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        LocalDateTime localTime = LocalDateTime.now();
        String date = DateKit.gmtDate(localTime);
        response.headers().set("Date", (Object)date);
        String lastModifed = date;
        LocalDateTime newTime = localTime.plusSeconds(60L);
        date = DateKit.gmtDate(newTime);
        response.headers().set("Expires", (Object)date);
        response.headers().set("Cache-Control", (Object)"private, max-age=60");
        if (null != fileToCache) {
            lastModifed = DateKit.gmtDate(new Date(fileToCache.lastModified()));
        }
        response.headers().set("Last-Modified", (Object)lastModifed);
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = StringKit.mimeType(file.getName());
        if (null == contentType) {
            contentType = URLConnection.guessContentTypeFromName(file.getName());
        }
        response.headers().set("Content-Type", (Object)contentType);
    }
}

