/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.exception.ExceptionResolve;
import com.blade.server.netty.HttpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Blade blade;
    private final SslContext sslCtx;
    private ExceptionResolve exceptionResolve;
    private boolean enableGzip;
    private boolean enableCors;

    public HttpServerInitializer(Blade blade, ExceptionResolve exceptionResolve, SslContext sslCtx) {
        this.blade = blade;
        this.sslCtx = null;
        this.exceptionResolve = exceptionResolve;
        this.enableGzip = blade.environment().getBoolean("http.gzip.enable", false);
        this.enableCors = blade.environment().getBoolean("http.cors.enable", false);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        if (this.enableGzip) {
            p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        }
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        if (this.enableCors) {
            CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build();
            p.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
        }
        p.addLast(new ChannelHandler[]{new HttpServerHandler(this.blade, this.exceptionResolve)});
    }
}

