/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import com.blade.kit.IOKit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private Properties props = new Properties();

    public static Environment empty() {
        return new Environment();
    }

    public static Environment of(@NonNull Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        Environment environment = new Environment();
        environment.props = props;
        return environment;
    }

    public static Environment of(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        Environment environment = new Environment();
        map.forEach((key, value) -> environment.props.setProperty((String)key, (String)value));
        return environment;
    }

    public Environment of(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        try {
            return Environment.of(url.openStream());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public static Environment of(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            return Environment.of(Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Environment of(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (location.startsWith("classpath:")) {
            location = location.substring("classpath:".length());
            return Environment.loadClasspath(location);
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
            new Environment();
            return Environment.of(new File(location));
        }
        if (location.startsWith("url:")) {
            location = location.substring("url:".length());
            try {
                return new Environment().of(new URL(location));
            }
            catch (MalformedURLException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        new Environment();
        return Environment.loadClasspath(location);
    }

    private static Environment loadClasspath(@NonNull String classpath) {
        InputStream is;
        if (classpath == null) {
            throw new NullPointerException("classpath");
        }
        if (classpath.startsWith("/")) {
            classpath = classpath.substring(1);
        }
        if (null == (is = Environment.getDefault().getResourceAsStream(classpath))) {
            return new Environment();
        }
        return Environment.of(is);
    }

    private static Environment of(@NonNull InputStream is) {
        if (is == null) {
            throw new NullPointerException("is");
        }
        try {
            Environment environment = new Environment();
            environment.props.load(is);
            Environment environment2 = environment;
            return environment2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOKit.closeQuietly(is);
        }
    }

    public static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = Environment.class.getClassLoader()) == null) {
            try {
                loader = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loader;
    }

    public Environment set(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.props.put(key, value);
        return this;
    }

    public Environment add(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.props.put(key, value);
        return this;
    }

    public Environment addAll(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        map.forEach((key, value) -> this.props.setProperty((String)key, (String)value));
        return this;
    }

    public Environment addAll(@NonNull Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.props.setProperty(key.toString(), value.toString())));
        return this;
    }

    public Optional<String> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Optional.ofNullable(this.props.getProperty(key));
    }

    public String get(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.props.getProperty(key, defaultValue);
    }

    public Optional<Object> getObject(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return Optional.ofNullable(this.props.get(key));
    }

    public Optional<Integer> getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getObject(key).isPresent()) {
            return Optional.of(Integer.parseInt(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Integer getInt(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getInt(key).isPresent()) {
            return this.getInt(key).get();
        }
        return defaultValue;
    }

    public Optional<Long> getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getObject(key).isPresent()) {
            return Optional.of(Long.parseLong(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Long getLong(@NonNull String key, long defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getLong(key).isPresent()) {
            return this.getLong(key).get();
        }
        return defaultValue;
    }

    public Optional<Boolean> getBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getObject(key).isPresent()) {
            return Optional.of(Boolean.parseBoolean(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Boolean getBoolean(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getBoolean(key).isPresent()) {
            return this.getBoolean(key).get();
        }
        return defaultValue;
    }

    public boolean hasKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.props.containsKey(key);
    }

    public boolean hasValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.props.containsValue(value);
    }

    public Optional<Double> getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getObject(key).isPresent()) {
            return Optional.of(Double.parseDouble(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Double getDouble(@NonNull String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.getDouble(key).isPresent()) {
            return this.getDouble(key).get();
        }
        return defaultValue;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.props.size());
        this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
        return map;
    }

    public Properties props() {
        return this.props;
    }

    private Environment() {
    }
}

