/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.event.BeanProcessor;
import com.blade.event.EventType;
import com.blade.exception.ExceptionResolve;
import com.blade.ioc.BeanDefine;
import com.blade.ioc.DynamicContext;
import com.blade.ioc.Ioc;
import com.blade.ioc.OrderComparator;
import com.blade.ioc.annotation.Bean;
import com.blade.ioc.reader.ClassInfo;
import com.blade.kit.BladeKit;
import com.blade.kit.NamedThreadFactory;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.route.RouteBuilder;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.DefaultUI;
import com.blade.mvc.ui.template.DefaultEngine;
import com.blade.server.Server;
import com.blade.server.netty.HttpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Blade blade;
    private Environment environment;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ExecutorService bossExecutors;
    private ExecutorService workerExecutors;
    private int threadCount;
    private int workers;
    private int backlog;
    private Channel channel;
    private RouteBuilder routeBuilder;
    private ExceptionResolve exceptionResolve;
    private List<BeanProcessor> beanProcessors = new ArrayList<BeanProcessor>();

    @Override
    public void start(Blade blade, String[] args) throws Exception {
        this.blade = blade;
        this.environment = blade.environment();
        long initStart = System.currentTimeMillis();
        log.info("Environment: jdk.version\t\t\t=> {}", (Object)System.getProperty("java.version"));
        log.info("Environment: user.dir\t\t\t=> {}", (Object)System.getProperty("user.dir"));
        log.info("Environment: java.io.tmpdir\t\t=> {}", (Object)System.getProperty("java.io.tmpdir"));
        log.info("Environment: user.timezone\t\t=> {}", (Object)System.getProperty("user.timezone"));
        log.info("Environment: file.encoding\t\t=> {}", (Object)System.getProperty("file.encoding"));
        log.info("Environment: classpath\t\t\t=> {}", (Object)Const.CLASSPATH);
        this.loadConfig(args);
        this.initConfig();
        WebContext.init(blade, "/", false);
        this.initIoc();
        this.startServer(initStart);
    }

    private void initIoc() {
        List<BeanDefine> beanDefines;
        RouteMatcher routeMatcher = this.blade.routeMatcher();
        routeMatcher.initMiddleware(this.blade.middleware());
        this.routeBuilder = new RouteBuilder(routeMatcher);
        this.blade.scanPackages().stream().flatMap(DynamicContext::recursionFindClasses).map(ClassInfo::getClazz).filter(ReflectKit::isNormalClass).forEach(this::parseCls);
        routeMatcher.register();
        this.beanProcessors.stream().sorted(new OrderComparator()).forEach(b -> b.preHandle(this.blade));
        Ioc ioc = this.blade.ioc();
        if (BladeKit.isNotEmpty(ioc.getBeans())) {
            log.info("\u2b22 Register bean: {}", ioc.getBeans());
        }
        if (BladeKit.isNotEmpty(beanDefines = ioc.getBeanDefines())) {
            beanDefines.forEach(b -> BladeKit.injection(ioc, b));
        }
        this.beanProcessors.stream().sorted(new OrderComparator()).forEach(b -> b.processor(this.blade));
    }

    private void startServer(long startTime) throws Exception {
        SslContext sslCtx = null;
        boolean SSL = false;
        this.bossGroup = new NioEventLoopGroup(this.threadCount, (Executor)this.bossExecutors);
        this.workerGroup = new NioEventLoopGroup(this.workers, (Executor)this.workerExecutors);
        ServerBootstrap b = new ServerBootstrap();
        b.option(ChannelOption.SO_BACKLOG, (Object)this.backlog);
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new HttpServerInitializer(this.blade, this.exceptionResolve, sslCtx));
        String address = this.environment.get("server.address", "0.0.0.0");
        int port = this.environment.getInt("server.port", 9000);
        this.channel = b.bind(address, port).sync().channel();
        String appName = this.environment.get("app.name", "Blade");
        log.info("\u2b22 {} initialize successfully, Time elapsed: {} ms", (Object)appName, (Object)(System.currentTimeMillis() - startTime));
        log.info("\u2b22 Blade start with {}:{}", (Object)address, (Object)port);
        log.info("\u2b22 Open your web browser and navigate to {}://{}:{} \u26a1", new Object[]{SSL ? "https" : "http", address.replace("0.0.0.0", "127.0.0.1"), port});
        this.blade.eventManager().fireEvent(EventType.SERVER_STARTED, this.blade);
    }

    private void parseCls(Class<?> clazz) {
        if (null != clazz.getAnnotation(Bean.class)) {
            this.blade.register(clazz);
        }
        if (null != clazz.getAnnotation(Path.class)) {
            if (null == clazz.getAnnotation(Bean.class)) {
                this.blade.register(clazz);
            }
            Object controller = this.blade.ioc().getBean(clazz);
            this.routeBuilder.addRouter(clazz, controller);
        }
        if (ReflectKit.hasInterface(clazz, WebHook.class) && null != clazz.getAnnotation(Bean.class)) {
            Object hook = this.blade.ioc().getBean(clazz);
            this.routeBuilder.addWebHook(clazz, hook);
        }
        if (ReflectKit.hasInterface(clazz, BeanProcessor.class) && null != clazz.getAnnotation(Bean.class)) {
            this.beanProcessors.add((BeanProcessor)this.blade.ioc().getBean(clazz));
        }
        if (ReflectKit.hasInterface(clazz, ExceptionResolve.class) && null != clazz.getAnnotation(Bean.class)) {
            this.exceptionResolve = (ExceptionResolve)this.blade.ioc().getBean(clazz);
        }
    }

    private void loadConfig(String[] args) {
        String bootConf = this.blade.environment().get("boot_conf", "classpath:app.properties");
        Environment bootEnv = Environment.of(bootConf);
        if (bootEnv != null) {
            bootEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
        }
        this.blade.register(this.environment);
        if (!BladeKit.isEmpty(args)) {
            for (int i = 0; i < args.length; ++i) {
                int pos;
                if (args[i].startsWith("-Dserver.address=")) {
                    pos = args[i].indexOf("-Dserver.address=") + "-Dserver.address=".length();
                    String address = args[i].substring(pos);
                    this.environment.set("server.address", address);
                    continue;
                }
                if (!args[i].startsWith("-Dserver.port=")) continue;
                pos = args[i].indexOf("-Dserver.port=") + "-Dserver.port=".length();
                String port = args[i].substring(pos);
                this.environment.set("server.port", port);
            }
        }
    }

    private void initConfig() {
        String templatePath;
        if (null != this.blade.bootClass()) {
            this.blade.scanPackages(this.blade.bootClass().getPackage().getName());
        }
        DefaultUI.printBanner();
        String statics = this.environment.get("mvc.statics", "");
        if (StringKit.isNotBlank(statics)) {
            this.blade.addStatics(statics.split(","));
        }
        if ((templatePath = this.environment.get("mvc.template.path", "templates")).charAt(0) == '/') {
            templatePath = templatePath.substring(1);
        }
        if (templatePath.endsWith("/")) {
            templatePath = templatePath.substring(0, templatePath.length() - 1);
        }
        DefaultEngine.TEMPLATE_PATH = templatePath;
        String boosGroupName = this.environment.get("server.netty.boos-name", "pool");
        String workerGroupName = this.environment.get("server.netty.worker-name", "pool");
        this.bossExecutors = Executors.newCachedThreadPool(new NamedThreadFactory("boss@" + boosGroupName));
        this.workerExecutors = Executors.newCachedThreadPool(new NamedThreadFactory("worker@" + workerGroupName));
        this.threadCount = this.environment.getInt("server.netty.thread-count", 1);
        this.workers = this.environment.getInt("server.netty.workers", 0);
        this.backlog = this.environment.getInt("server.netty.backlog", 1024);
    }

    @Override
    public void stop() {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossExecutors != null) {
            this.bossExecutors.shutdown();
        }
        if (this.workerExecutors != null) {
            this.workerExecutors.shutdown();
        }
    }

    @Override
    public void join() throws InterruptedException {
        try {
            this.channel.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stop();
        }
    }
}

