/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.annotation.DeleteRoute;
import com.blade.mvc.annotation.GetRoute;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.annotation.PostRoute;
import com.blade.mvc.annotation.PutRoute;
import com.blade.mvc.annotation.Route;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.route.RouteMatcher;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBuilder {
    private static final Logger log = LoggerFactory.getLogger(RouteBuilder.class);
    private RouteMatcher routeMatcher;

    public RouteBuilder(RouteMatcher routeMatcher) {
        this.routeMatcher = routeMatcher;
    }

    public void addWebHook(Class<?> webHook, Object hook) {
        Path path = webHook.getAnnotation(Path.class);
        String pattern = "/.*";
        if (null != path) {
            pattern = path.value();
        }
        Method before = ReflectKit.getMethod(webHook, "before", Signature.class);
        Method after = ReflectKit.getMethod(webHook, "after", Signature.class);
        this.buildRoute(webHook, hook, before, pattern, HttpMethod.BEFORE);
        this.buildRoute(webHook, hook, after, pattern, HttpMethod.AFTER);
    }

    public void addRouter(Class<?> router, Object controller) {
        Method[] methods = router.getMethods();
        if (BladeKit.isEmpty(methods)) {
            return;
        }
        String nameSpace = null;
        String suffix = null;
        if (null != router.getAnnotation(Path.class)) {
            nameSpace = router.getAnnotation(Path.class).value();
            suffix = router.getAnnotation(Path.class).suffix();
        }
        if (null == nameSpace) {
            log.warn("Route [{}] not controller annotation", (Object)router.getName());
            return;
        }
        for (Method method : methods) {
            Route mapping = method.getAnnotation(Route.class);
            GetRoute getRoute = method.getAnnotation(GetRoute.class);
            PostRoute postRoute = method.getAnnotation(PostRoute.class);
            PutRoute putRoute = method.getAnnotation(PutRoute.class);
            DeleteRoute deleteRoute = method.getAnnotation(DeleteRoute.class);
            this.parseRoute(mapping, nameSpace, suffix, router, controller, method);
            this.parseGetRoute(getRoute, nameSpace, suffix, router, controller, method);
            this.parsePostRoute(postRoute, nameSpace, suffix, router, controller, method);
            this.parsePutRoute(putRoute, nameSpace, suffix, router, controller, method);
            this.parseDeleteRoute(deleteRoute, nameSpace, suffix, router, controller, method);
        }
    }

    private void parseRoute(Route mapping, String nameSpace, String suffix, Class<?> router, Object controller, Method method) {
        if (null != mapping) {
            HttpMethod methodType = mapping.method();
            String[] paths = mapping.value();
            if (paths.length > 0) {
                for (String path : paths) {
                    String pathV = this.getRoutePath(path, nameSpace, suffix);
                    this.buildRoute(router, controller, method, pathV, methodType);
                }
            }
        }
    }

    private void parseGetRoute(GetRoute getRoute, String nameSpace, String suffix, Class<?> router, Object controller, Method method) {
        String[] paths;
        if (null != getRoute && (paths = getRoute.value()).length > 0) {
            for (String path : paths) {
                String pathV = this.getRoutePath(path, nameSpace, suffix);
                this.buildRoute(router, controller, method, pathV, HttpMethod.GET);
            }
        }
    }

    private void parsePostRoute(PostRoute postRoute, String nameSpace, String suffix, Class<?> router, Object controller, Method method) {
        String[] paths;
        if (null != postRoute && (paths = postRoute.value()).length > 0) {
            for (String path : paths) {
                String pathV = this.getRoutePath(path, nameSpace, suffix);
                this.buildRoute(router, controller, method, pathV, HttpMethod.POST);
            }
        }
    }

    private void parsePutRoute(PutRoute putRoute, String nameSpace, String suffix, Class<?> router, Object controller, Method method) {
        String[] paths;
        if (null != putRoute && (paths = putRoute.value()).length > 0) {
            for (String path : paths) {
                String pathV = this.getRoutePath(path, nameSpace, suffix);
                this.buildRoute(router, controller, method, pathV, HttpMethod.PUT);
            }
        }
    }

    private void parseDeleteRoute(DeleteRoute deleteRoute, String nameSpace, String suffix, Class<?> router, Object controller, Method method) {
        String[] paths;
        if (null != deleteRoute && (paths = deleteRoute.value()).length > 0) {
            for (String path : paths) {
                String pathV = this.getRoutePath(path, nameSpace, suffix);
                this.buildRoute(router, controller, method, pathV, HttpMethod.DELETE);
            }
        }
    }

    private String getRoutePath(String value, String nameSpace, String suffix) {
        String path = value.startsWith("/") ? value : "/" + value;
        nameSpace = nameSpace.startsWith("/") ? nameSpace : "/" + nameSpace;
        path = nameSpace + path;
        path = path.replaceAll("[/]+", "/");
        path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        path = path + suffix;
        return path;
    }

    private void buildRoute(Class<?> clazz, Object controller, Method execMethod, String path, HttpMethod method) {
        this.routeMatcher.addRoute(method, path, controller, clazz, execMethod);
    }
}

