/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public final class PathKit {
    public static final String VAR_REGEXP = ":(\\w+)";
    public static final String VAR_REPLACE = "([^#/?.]+)";
    public static final String SLASH = "/";

    public static String getRelativePath(String path, String contextPath) {
        if (!(path = path.substring((contextPath = null == contextPath ? "" : contextPath).length())).startsWith(SLASH)) {
            path = SLASH + path;
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    public static List<String> convertRouteToList(String route) {
        String[] pathArray = route.split(SLASH);
        if (null != pathArray && pathArray.length > 0) {
            ArrayList<String> path = new ArrayList<String>();
            for (String p : pathArray) {
                if (p.length() <= 0) continue;
                path.add(p);
            }
            return path;
        }
        return new ArrayList<String>(0);
    }

    public static boolean isParam(String routePart) {
        return routePart.startsWith(":");
    }

    public static boolean isSplat(String routePart) {
        return routePart.equals("*");
    }

    public static String fixPath(String path) {
        if (null == path) {
            return SLASH;
        }
        if (path.charAt(0) != '/') {
            path = SLASH + path;
        }
        if (path.length() > 1 && path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.contains("\\s")) {
            return path;
        }
        return path.replaceAll("\\s", "%20");
    }

    public static String cleanPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replaceAll("[/]+", SLASH);
    }
}

