/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlHelper {
    private static final Log logger = LogFactory.getLog(SqlHelper.class);

    public static SqlSession sqlSession(Class<?> clazz) {
        return SqlHelper.sqlSession(clazz, true);
    }

    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        SqlSession sqlSession = SqlHelper.getSqlSession(clazz, true);
        return sqlSession != null ? sqlSession : GlobalConfiguration.currentSessionFactory(clazz).openSession(ExecutorType.BATCH, false);
    }

    private static SqlSession getSqlSession(Class<?> clazz, boolean isBatch) {
        SqlSession session = null;
        try {
            SqlSessionFactory sqlSessionFactory = GlobalConfiguration.currentSessionFactory(clazz);
            Configuration configuration = sqlSessionFactory.getConfiguration();
            GlobalConfiguration globalConfiguration = GlobalConfiguration.getGlobalConfig(configuration);
            session = isBatch ? globalConfiguration.getSqlsessionBatch() : globalConfiguration.getSqlSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return session;
    }

    public static SqlSession sqlSession(Class<?> clazz, boolean autoCommit) {
        SqlSession sqlSession = SqlHelper.getSqlSession(clazz, false);
        return sqlSession != null ? sqlSession : GlobalConfiguration.currentSessionFactory(clazz).openSession(autoCommit);
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (null == tableInfo) {
            throw new MybatisPlusException("Error: Cannot execute table Method, ClassGenricType not found .");
        }
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null == result ? false : result >= 1;
    }

    public static int retCount(Integer result) {
        return null == result ? 0 : result;
    }

    public static <E> E getObject(List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    public static void fillWrapper(Page<?> page, Wrapper<?> wrapper) {
        if (null != wrapper) {
            wrapper.orderBy(page.getOrderByField(), page.isAsc());
            wrapper.allEq(page.getCondition());
        }
    }
}

