/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.entity;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.enums.FieldStrategy;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.mapper.IMetaObjectHandler;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import com.baomidou.mybatisplus.toolkit.IOUtils;
import com.baomidou.mybatisplus.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfiguration
implements Cloneable,
Serializable {
    private static final Log logger = LogFactory.getLog(GlobalConfiguration.class);
    private static final Map<String, GlobalConfiguration> GLOBAL_CONFIG = new ConcurrentHashMap<String, GlobalConfiguration>();
    public static final GlobalConfiguration DEFAULT = new GlobalConfiguration();
    private DBType dbType = DBType.MYSQL;
    private IdType idType = IdType.ID_WORKER;
    private boolean dbColumnUnderline = false;
    private ISqlInjector sqlInjector;
    private IMetaObjectHandler metaObjectHandler = null;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;
    private boolean isRefresh = false;
    private boolean isAutoSetDbType = true;
    private boolean isCapitalMode = false;
    private String identifierQuote;
    private SqlSessionFactory sqlSessionFactory;
    private Set<String> mapperRegistryCache = new ConcurrentSkipListSet<String>();
    private SqlSession sqlSession;
    private SqlSession sqlsessionBatch;

    public GlobalConfiguration() {
    }

    public GlobalConfiguration(ISqlInjector sqlInjector) {
        this.sqlInjector = sqlInjector;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = DBType.getDBType(dbType);
        this.isAutoSetDbType = false;
    }

    public void setDbTypeByJdbcUrl(String jdbcUrl) {
        this.dbType = JdbcUtils.getDbType(jdbcUrl);
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(int idType) {
        this.idType = IdType.getIdType(idType);
    }

    public boolean isDbColumnUnderline() {
        return this.dbColumnUnderline;
    }

    public void setDbColumnUnderline(boolean dbColumnUnderline) {
        this.dbColumnUnderline = dbColumnUnderline;
    }

    public ISqlInjector getSqlInjector() {
        return this.sqlInjector;
    }

    public void setSqlInjector(ISqlInjector sqlInjector) {
        this.sqlInjector = sqlInjector;
    }

    public IMetaObjectHandler getMetaObjectHandler() {
        return this.metaObjectHandler;
    }

    public void setMetaObjectHandler(IMetaObjectHandler metaObjectHandler) {
        this.metaObjectHandler = metaObjectHandler;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(int fieldStrategy) {
        this.fieldStrategy = FieldStrategy.getFieldStrategy(fieldStrategy);
    }

    public boolean isRefresh() {
        return this.isRefresh;
    }

    public void setRefresh(boolean refresh) {
        this.isRefresh = refresh;
    }

    public boolean isAutoSetDbType() {
        return this.isAutoSetDbType;
    }

    public void setAutoSetDbType(boolean autoSetDbType) {
        this.isAutoSetDbType = autoSetDbType;
    }

    public Set<String> getMapperRegistryCache() {
        return this.mapperRegistryCache;
    }

    public void setMapperRegistryCache(Set<String> mapperRegistryCache) {
        this.mapperRegistryCache = mapperRegistryCache;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.sqlSession = new SqlSessionTemplate(sqlSessionFactory);
        this.sqlsessionBatch = new SqlSessionTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public void setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
    }

    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    public void setIdentifierQuote(String identifierQuote) {
        this.identifierQuote = identifierQuote;
    }

    public void setSqlKeywords(String sqlKeywords) {
        if (StringUtils.isNotEmpty(sqlKeywords)) {
            SqlReservedWords.RESERVED_WORDS.addAll(StringUtils.splitWorker(sqlKeywords.toUpperCase(), ",", -1, false));
        }
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public SqlSession getSqlsessionBatch() {
        return this.sqlsessionBatch;
    }

    protected GlobalConfiguration clone() throws CloneNotSupportedException {
        return (GlobalConfiguration)super.clone();
    }

    public static SqlSessionFactory currentSessionFactory(Class<?> clazz) {
        String configMark = TableInfoHelper.getTableInfo(clazz).getConfigMark();
        GlobalConfiguration mybatisGlobalConfig = GlobalConfiguration.getGlobalConfig(configMark);
        return mybatisGlobalConfig.getSqlSessionFactory();
    }

    public static GlobalConfiguration defaults() {
        try {
            GlobalConfiguration clone = DEFAULT.clone();
            clone.setSqlInjector(new AutoSqlInjector());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new MybatisPlusException("ERROR: CLONE MybatisGlobalConfig DEFAULT FAIL !  Cause:" + e);
        }
    }

    public static void setGlobalConfig(Configuration configuration, GlobalConfiguration mybatisGlobalConfig) {
        if (configuration == null || mybatisGlobalConfig == null) {
            new MybatisPlusException("Error: Could not setGlobalConfig");
        }
        GLOBAL_CONFIG.put(configuration.toString(), mybatisGlobalConfig);
    }

    public SqlSessionFactory signGlobalConfig(SqlSessionFactory sqlSessionFactory) {
        if (null != sqlSessionFactory) {
            GlobalConfiguration.setGlobalConfig(sqlSessionFactory.getConfiguration(), this);
        }
        return sqlSessionFactory;
    }

    public static GlobalConfiguration getGlobalConfig(Configuration configuration) {
        if (configuration == null) {
            throw new MybatisPlusException("Error: You need Initialize MybatisConfiguration !");
        }
        return GlobalConfiguration.getGlobalConfig(configuration.toString());
    }

    public static GlobalConfiguration getGlobalConfig(String configMark) {
        GlobalConfiguration cache = GLOBAL_CONFIG.get(configMark);
        if (cache == null) {
            logger.debug("DeBug: MyBatis Plus Global configuration Initializing !");
            GLOBAL_CONFIG.put(configMark, DEFAULT);
            return DEFAULT;
        }
        return cache;
    }

    public static DBType getDbType(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getDbType();
    }

    public static IdType getIdType(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getIdType();
    }

    public static boolean isDbColumnUnderline(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).isDbColumnUnderline();
    }

    public static ISqlInjector getSqlInjector(Configuration configuration) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getGlobalConfig(configuration);
        ISqlInjector sqlInjector = globalConfiguration.getSqlInjector();
        if (sqlInjector == null) {
            sqlInjector = new AutoSqlInjector();
            globalConfiguration.setSqlInjector(sqlInjector);
        }
        return sqlInjector;
    }

    public static IMetaObjectHandler getMetaObjectHandler(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getMetaObjectHandler();
    }

    public static FieldStrategy getFieldStrategy(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getFieldStrategy();
    }

    public static boolean isRefresh(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).isRefresh();
    }

    public static boolean isAutoSetDbType(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).isAutoSetDbType();
    }

    public static Set<String> getMapperRegistryCache(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getMapperRegistryCache();
    }

    public static String getIdentifierQuote(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getIdentifierQuote();
    }

    public static SqlSession getSqlSession(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getSqlSession();
    }

    public static SqlSession getSqlsessionBatch(Configuration configuration) {
        return GlobalConfiguration.getGlobalConfig(configuration).getSqlsessionBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMetaData(DataSource dataSource, GlobalConfiguration globalConfig) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String jdbcUrl = connection.getMetaData().getURL();
            globalConfig.setSqlKeywords(connection.getMetaData().getSQLKeywords());
            if (globalConfig.isAutoSetDbType()) {
                globalConfig.setDbTypeByJdbcUrl(jdbcUrl);
            }
        }
        catch (SQLException e) {
            logger.warn("Warn: GlobalConfiguration setMetaData Fail !  Cause:" + e);
        }
        finally {
            IOUtils.closeQuietly(connection);
        }
    }
}

