/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jms.AbstractJmsProxy;
import com.atomikos.jms.AbstractJmsSessionProxy;
import com.atomikos.jms.AtomikosJMSException;
import com.atomikos.jms.AtomikosJmsNonXaSessionProxy;
import com.atomikos.jms.AtomikosJmsXaSessionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.DynamicProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;

class AtomikosJmsConnectionProxy
extends AbstractJmsProxy
implements SessionHandleStateChangeListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsConnectionProxy.class);
    private static Class<?>[] MINIMUM_SET_OF_INTERFACES = new Class[]{Reapable.class, DynamicProxy.class, Connection.class};
    private static final String CREATE_SESSION_METHOD = "createSession";
    private static final String CLOSE_METHOD = "close";
    private static final String REAP_METHOD = "reap";
    private XAConnection delegate;
    private XATransactionalResource jmsTransactionalResource;
    private List<Session> sessions;
    private boolean closed;
    private boolean reaped;
    private SessionHandleStateChangeListener owner;
    private ConnectionPoolProperties props;
    private boolean erroneous;
    private boolean ignoreSessionTransactedFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceConnectionIntoXaMode(Connection c) {
        Session s = null;
        try {
            s = c.createSession(true, 1);
            s.rollback();
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("JMS: driver complains while enforcing XA mode - ignore if no later errors:", (Throwable)e);
            }
        }
        finally {
            block14: {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (JMSException e) {
                        if (!LOGGER.isTraceEnabled()) break block14;
                        LOGGER.logTrace("JMS: driver complains while enforcing XA mode - ignore if no later errors:", (Throwable)e);
                    }
                }
            }
        }
    }

    private AtomikosJmsConnectionProxy(boolean ignoreSessionTransactedFlag, XAConnection c, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener owner, ConnectionPoolProperties props) {
        this.delegate = c;
        this.sessions = new ArrayList<Session>();
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.closed = false;
        this.reaped = false;
        this.owner = owner;
        this.props = props;
        this.ignoreSessionTransactedFlag = ignoreSessionTransactedFlag;
    }

    private void reap() {
        LOGGER.logWarning(this + ": reaping - check if the application closes connections correctly, or increase the reapTimeout value");
        this.close();
        this.erroneous = true;
        this.reaped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(Session session) {
        List<Session> list = this.sessions;
        synchronized (list) {
            this.sessions.add(session);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws JMSException {
        String methodName = method.getName();
        if (methodName.equals("getInvocationHandler")) {
            return this;
        }
        try {
            if (methodName.equals(REAP_METHOD)) {
                this.reap();
                return null;
            }
            if (CLOSE_METHOD.equals(methodName)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(this + ": intercepting call to close");
                }
                this.close();
                return null;
            }
            if (this.reaped) {
                String msg = "Connection was reaped - calling method " + methodName + " no longer allowed. Increase the reapTimeout to avoid this.";
                LOGGER.logWarning(this + ": " + msg);
                throw new IllegalStateException(msg);
            }
            if (this.closed && !this.methodAllowedAfterClose(method)) {
                String msg = "Connection is closed already - calling method " + methodName + " no longer allowed.";
                LOGGER.logWarning(this + ": " + msg);
                throw new IllegalStateException(msg);
            }
            if (CREATE_SESSION_METHOD.equals(methodName)) {
                Boolean transactedFlag = (Boolean)args[0];
                Session session = null;
                if (this.createXaSession(transactedFlag)) {
                    session = this.recycleSession();
                    if (session == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.logDebug(this + ": creating XA-capable session...");
                        }
                        AtomikosJmsConnectionProxy.forceConnectionIntoXaMode((Connection)this.delegate);
                        XASession wrapped = null;
                        try {
                            wrapped = this.delegate.createXASession();
                        }
                        catch (JMSException vendorError) {
                            String msg = "Could not create an XASession on the javax.jms.XAConnectionFactory's XAConnection - check if your JMS backend is configured for XA?";
                            this.convertProxyError(vendorError, msg);
                        }
                        session = (Session)AtomikosJmsXaSessionProxy.newInstance(wrapped, this.jmsTransactionalResource, this.owner, this);
                        this.addSession(session);
                    }
                } else {
                    CompositeTransaction ct = null;
                    CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
                    if (ctm != null) {
                        ct = ctm.getCompositeTransaction();
                    }
                    if (ct != null && ct.getProperty("com.atomikos.icatch.jta.transaction") != null && LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": creating NON-XA session - the resulting JMS work will NOT be part of the JTA transaction!");
                    }
                    Integer ackMode = (Integer)args[1];
                    Session wrapped = null;
                    try {
                        wrapped = this.delegate.createSession(transactedFlag.booleanValue(), ackMode.intValue());
                    }
                    catch (JMSException vendorError) {
                        String msg = "Could not create a non-XA session on the javax.jms.XAConnectionFactory's XAConnection - check your JMS vendor's documentation to see if non-XA use of its XAConnection is supported?";
                        this.convertProxyError(vendorError, msg);
                    }
                    session = (Session)AtomikosJmsNonXaSessionProxy.newInstance(wrapped, this.owner, this);
                    this.addSession(session);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(this + ": returning " + session);
                }
                return session;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": calling " + methodName + " on JMS driver...");
            }
            Object ret = method.invoke((Object)this.delegate, args);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": " + methodName + " returning " + ret);
            }
            return ret;
        }
        catch (AtomikosJMSException e) {
            this.erroneous = true;
            throw e;
        }
        catch (Exception e) {
            String msg = "Error delegating '" + methodName + "' call to JMS driver";
            this.erroneous = true;
            this.convertProxyError(e, msg);
            return null;
        }
    }

    private boolean methodAllowedAfterClose(Method method) {
        return method.getName().equals(CLOSE_METHOD) || ClassLoadingHelper.existsInJavaObjectClass((Method)method);
    }

    private boolean createXaSession(boolean sessionTransactedFlag) {
        if (this.ignoreSessionTransactedFlag) {
            return !this.props.getLocalTransactionMode();
        }
        return sessionTransactedFlag && !this.props.getLocalTransactionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session recycleSession() {
        CompositeTransactionManager tm = Configuration.getCompositeTransactionManager();
        if (tm == null) {
            return null;
        }
        CompositeTransaction current = tm.getCompositeTransaction();
        if (current != null && current.getProperty("com.atomikos.icatch.jta.transaction") != null) {
            List<Session> list = this.sessions;
            synchronized (list) {
                for (int i = 0; i < this.sessions.size(); ++i) {
                    Session session = this.sessions.get(i);
                    DynamicProxy dproxy = (DynamicProxy)session;
                    AbstractJmsSessionProxy proxy = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                    if (!proxy.isInactiveTransaction(current) && !proxy.isInTransaction(current)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": recycling session " + proxy);
                    }
                    proxy.recycle();
                    return session;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": close()...");
        }
        this.closed = true;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closing " + this.sessions.size() + " session(s)");
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                Session session = this.sessions.get(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException ex) {
                    LOGGER.logWarning(this + ": error closing session " + session, (Throwable)ex);
                }
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": is available ? " + this.isAvailable());
        }
        if (this.isAvailable()) {
            this.owner.onTerminated();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroy() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closing connection and all " + this.sessions.size() + " session(s)");
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                Session session = this.sessions.get(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException ex) {
                    LOGGER.logWarning(this + ": error closing session " + session, (Throwable)ex);
                }
            }
        }
        this.sessions.clear();
    }

    public static Reapable newInstance(boolean ignoreSessionTransactedFlag, XAConnection c, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener owner, ConnectionPoolProperties props) {
        Reapable ret = null;
        AtomikosJmsConnectionProxy proxy = new AtomikosJmsConnectionProxy(ignoreSessionTransactedFlag, c, jmsTransactionalResource, owner, props);
        Set interfaces = PropertyUtils.getAllImplementedInterfaces(c.getClass());
        interfaces.add(Reapable.class);
        interfaces.add(DynamicProxy.class);
        Class[] interfaceClasses = interfaces.toArray(new Class[0]);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(c.getClass().getClassLoader());
        classLoaders.add(AtomikosJmsConnectionProxy.class.getClassLoader());
        ret = (Reapable)ClassLoadingHelper.newProxyInstance(classLoaders, (Class[])MINIMUM_SET_OF_INTERFACES, (Class[])interfaceClasses, (InvocationHandler)proxy);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        boolean ret = this.closed;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && ret) {
                Session handle = it.next();
                DynamicProxy dproxy = (DynamicProxy)handle;
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                if (session.isAvailable()) continue;
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isErroneous() {
        boolean ret = this.erroneous;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                DynamicProxy dproxy = (DynamicProxy)handle;
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                if (!session.isErroneous()) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                DynamicProxy dproxy = (DynamicProxy)handle;
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                if (!session.isInTransaction(ct)) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInactiveInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                DynamicProxy dproxy = (DynamicProxy)handle;
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                if (!session.isInactiveTransaction(ct)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public String toString() {
        return "atomikos connection proxy for resource " + this.jmsTransactionalResource.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onTerminated() {
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext()) {
                Session handle = it.next();
                DynamicProxy dproxy = (DynamicProxy)handle;
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)dproxy.getInvocationHandler();
                if (!session.isAvailable()) continue;
                it.remove();
            }
        }
    }
}

