/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.io.LocalizedIOException;
import com.aoindustries.util.ApplicationResourcesAccessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties loadFromFile(File file) throws IOException {
        Properties props = new Properties();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            props.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromResource(Class<?> clazz, String resource) throws IOException {
        Properties props = new Properties();
        InputStream in = clazz.getResourceAsStream(resource);
        if (in == null) {
            throw new LocalizedIOException(ApplicationResourcesAccessor.accessor, "PropertiesUtils.readProperties.resourceNotFound", new Serializable[]{resource});
        }
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }
}

