/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.text.Collator;
import java.util.Locale;

public final class ComparatorUtils {
    private static final Collator collator = Collator.getInstance(Locale.ROOT);

    private ComparatorUtils() {
    }

    public static int compare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static int compare(short s1, short s2) {
        return s1 < s2 ? -1 : (s1 == s2 ? 0 : 1);
    }

    public static int compare(boolean b1, boolean b2) {
        return b1 == b2 ? 0 : (b1 ? 1 : -1);
    }

    public static int compare(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    public static int compareIgnoreCaseConsistentWithEquals(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        int diff = collator.compare(s1, s2);
        if (diff != 0) {
            return diff;
        }
        return s1.compareTo(s2);
    }
}

