/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.security;

import com.aoindustries.io.IoUtils;
import com.aoindustries.math.LongLong;
import com.aoindustries.math.UnsignedLong;
import com.aoindustries.security.Identifier;
import java.io.Serializable;
import java.util.Random;

public class SmallIdentifier
implements Serializable,
Comparable<SmallIdentifier> {
    private static final long serialVersionUID = 1L;
    private final long value;

    public static SmallIdentifier valueOf(String encoded) throws IllegalArgumentException {
        return new SmallIdentifier(encoded);
    }

    public SmallIdentifier() {
        this(Identifier.secureRandom);
    }

    public SmallIdentifier(Random random) {
        byte[] bytes = new byte[8];
        random.nextBytes(bytes);
        this.value = IoUtils.bufferToLong(bytes);
    }

    public SmallIdentifier(long value) {
        this.value = value;
    }

    public SmallIdentifier(String encoded) throws IllegalArgumentException {
        if (encoded.length() != 11) {
            throw new IllegalArgumentException();
        }
        this.value = Identifier.decode(encoded);
    }

    public boolean equals(Object O) {
        if (!(O instanceof SmallIdentifier)) {
            return false;
        }
        return this.equals((SmallIdentifier)O);
    }

    public boolean equals(SmallIdentifier other) {
        return other != null && this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public String toString() {
        return new String(new char[]{Identifier.getCharacter(UnsignedLong.divide(this.value, 362033331456891249L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 6351461955384057L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 111429157112001L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 1954897493193L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 34296447249L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 601692057L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 10556001L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 185193L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 3249L)), Identifier.getCharacter(UnsignedLong.divide(this.value, 57L)), Identifier.getCharacter(this.value)});
    }

    @Override
    public int compareTo(SmallIdentifier other) {
        return LongLong.compareUnsigned(this.value, other.value);
    }

    public long getValue() {
        return this.value;
    }
}

