/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.lang.NullArgumentException;
import com.aoindustries.util.BufferManager;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IoUtils {
    private IoUtils() {
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoUtils.copy(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, boolean flush) throws IOException {
        byte[] buff = BufferManager.getBytes();
        try {
            int numBytes;
            long totalBytes = 0L;
            while ((numBytes = in.read(buff, 0, 4096)) != -1) {
                out.write(buff, 0, numBytes);
                if (flush) {
                    out.flush();
                }
                totalBytes += (long)numBytes;
            }
            long l = totalBytes;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, Writer out) throws IOException {
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.write(buff, 0, numChars);
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, Appendable out) throws IOException {
        if (in == null) {
            throw new NullArgumentException("in");
        }
        if (out == null) {
            throw new NullArgumentException("out");
        }
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.append(new String(buff, 0, numChars));
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, StringBuilder out) throws IOException {
        char[] buff = BufferManager.getChars();
        try {
            int numChars;
            long totalChars = 0L;
            while ((numChars = in.read(buff, 0, 4096)) != -1) {
                out.append(buff, 0, numChars);
                totalChars += (long)numChars;
            }
            long l = totalChars;
            return l;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        IoUtils.readFully(in, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream in, byte[] buffer, int off, int len) throws IOException {
        while (len > 0) {
            int count = in.read(buffer, off, len);
            if (count == -1) {
                throw new EOFException();
            }
            off += count;
            len -= count;
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IoUtils.copy(in, bout);
        return bout.toByteArray();
    }

    public static String readFully(Reader in) throws IOException {
        StringBuilder sb = new StringBuilder();
        IoUtils.copy(in, sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(InputStream in, byte[] contents) throws IOException {
        int contentLen = contents.length;
        byte[] buff = BufferManager.getBytes();
        try {
            int readPos = 0;
            while (readPos < contentLen) {
                int bytesRemaining = contentLen - readPos;
                int bytesRead = in.read(buff, 0, bytesRemaining > 4096 ? 4096 : bytesRemaining);
                if (bytesRead == -1) {
                    boolean bl = false;
                    return bl;
                }
                int i = 0;
                while (i < bytesRead) {
                    if (buff[i++] == contents[readPos++]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = in.read() == -1;
            return bl;
        }
        finally {
            BufferManager.release(buff, false);
        }
    }

    public static void charToBuffer(char ch, byte[] ioBuffer) {
        ioBuffer[0] = (byte)(ch >>> 8);
        ioBuffer[1] = (byte)ch;
    }

    public static void charToBuffer(char ch, byte[] ioBuffer, int off) {
        ioBuffer[off] = (byte)(ch >>> 8);
        ioBuffer[off + 1] = (byte)ch;
    }

    public static char bufferToChar(byte[] ioBuffer) {
        return (char)(ioBuffer[0] << 8 | ioBuffer[1] & 0xFF);
    }

    public static char bufferToChar(byte[] ioBuffer, int off) {
        return (char)(ioBuffer[off + 0] << 8 | ioBuffer[off + 1] & 0xFF);
    }

    public static void shortToBuffer(short s, byte[] ioBuffer) {
        ioBuffer[0] = (byte)(s >>> 8);
        ioBuffer[1] = (byte)s;
    }

    public static void shortToBuffer(short s, byte[] ioBuffer, int off) {
        ioBuffer[off] = (byte)(s >>> 8);
        ioBuffer[off + 1] = (byte)s;
    }

    public static short bufferToShort(byte[] ioBuffer) {
        return (short)(ioBuffer[0] << 8 | ioBuffer[1] & 0xFF);
    }

    public static short bufferToShort(byte[] ioBuffer, int off) {
        return (short)(ioBuffer[off + 0] << 8 | ioBuffer[off + 1] & 0xFF);
    }

    public static void intToBuffer(int i, byte[] ioBuffer) {
        ioBuffer[0] = (byte)(i >>> 24);
        ioBuffer[1] = (byte)(i >>> 16);
        ioBuffer[2] = (byte)(i >>> 8);
        ioBuffer[3] = (byte)i;
    }

    public static void intToBuffer(int i, byte[] ioBuffer, int off) {
        ioBuffer[off] = (byte)(i >>> 24);
        ioBuffer[off + 1] = (byte)(i >>> 16);
        ioBuffer[off + 2] = (byte)(i >>> 8);
        ioBuffer[off + 3] = (byte)i;
    }

    public static int bufferToInt(byte[] ioBuffer) {
        return (ioBuffer[0] << 24) + ((ioBuffer[1] & 0xFF) << 16) + ((ioBuffer[2] & 0xFF) << 8) + (ioBuffer[3] & 0xFF);
    }

    public static int bufferToInt(byte[] ioBuffer, int off) {
        return (ioBuffer[off] << 24) + ((ioBuffer[off + 1] & 0xFF) << 16) + ((ioBuffer[off + 2] & 0xFF) << 8) + (ioBuffer[off + 3] & 0xFF);
    }

    public static void longToBuffer(long l, byte[] ioBuffer) {
        ioBuffer[0] = (byte)(l >>> 56);
        ioBuffer[1] = (byte)(l >>> 48);
        ioBuffer[2] = (byte)(l >>> 40);
        ioBuffer[3] = (byte)(l >>> 32);
        ioBuffer[4] = (byte)(l >>> 24);
        ioBuffer[5] = (byte)(l >>> 16);
        ioBuffer[6] = (byte)(l >>> 8);
        ioBuffer[7] = (byte)l;
    }

    public static void longToBuffer(long l, byte[] ioBuffer, int off) {
        ioBuffer[off] = (byte)(l >>> 56);
        ioBuffer[off + 1] = (byte)(l >>> 48);
        ioBuffer[off + 2] = (byte)(l >>> 40);
        ioBuffer[off + 3] = (byte)(l >>> 32);
        ioBuffer[off + 4] = (byte)(l >>> 24);
        ioBuffer[off + 5] = (byte)(l >>> 16);
        ioBuffer[off + 6] = (byte)(l >>> 8);
        ioBuffer[off + 7] = (byte)l;
    }

    public static long bufferToLong(byte[] ioBuffer) {
        return (((long)ioBuffer[0] & 0xFFL) << 56) + (((long)ioBuffer[1] & 0xFFL) << 48) + (((long)ioBuffer[2] & 0xFFL) << 40) + (((long)ioBuffer[3] & 0xFFL) << 32) + (((long)ioBuffer[4] & 0xFFL) << 24) + (((long)ioBuffer[5] & 0xFFL) << 16) + (((long)ioBuffer[6] & 0xFFL) << 8) + ((long)ioBuffer[7] & 0xFFL);
    }

    public static long bufferToLong(byte[] ioBuffer, int off) {
        return (((long)ioBuffer[off] & 0xFFL) << 56) + (((long)ioBuffer[off + 1] & 0xFFL) << 48) + (((long)ioBuffer[off + 2] & 0xFFL) << 40) + (((long)ioBuffer[off + 3] & 0xFFL) << 32) + (((long)ioBuffer[off + 4] & 0xFFL) << 24) + (((long)ioBuffer[off + 5] & 0xFFL) << 16) + (((long)ioBuffer[off + 6] & 0xFFL) << 8) + ((long)ioBuffer[off + 7] & 0xFFL);
    }
}

