/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.BufferManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public final class FileUtils {
    private FileUtils() {
    }

    public static void delete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Unable to delete: " + file);
        }
    }

    public static void deleteRecursive(File file) throws IOException {
        File[] afile;
        if (file.isDirectory() && file.getCanonicalPath().equals(file.getAbsolutePath()) && (afile = file.listFiles()) != null) {
            for (File f : afile) {
                FileUtils.deleteRecursive(f);
            }
        }
        FileUtils.delete(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file, byte[] contents) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            return false;
        }
        if (length != 0L && length != (long)contents.length) {
            return false;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            boolean bl = IoUtils.contentEquals(in, contents);
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int contentHashCode(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            int readVal;
            int result = 1;
            while ((readVal = ((InputStream)in).read()) != -1) {
                result = 31 * result + (byte)readVal;
            }
            int n = result;
            return n;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtils.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File tempFile;
        do {
            tempFile = File.createTempFile(prefix, suffix, directory);
            FileUtils.delete(tempFile);
        } while (!tempFile.mkdir());
        return tempFile;
    }

    public static File copyToTempFile(InputStream in, String prefix, String suffix) throws IOException {
        return FileUtils.copyToTempFile(in, prefix, suffix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempFile(InputStream in, String prefix, String suffix, File directory) throws IOException {
        File tmpFile = File.createTempFile("cache_", null);
        boolean successful = false;
        try {
            FileOutputStream out = new FileOutputStream(tmpFile);
            try {
                IoUtils.copy(in, out);
            }
            finally {
                ((OutputStream)out).close();
            }
            successful = true;
            File file = tmpFile;
            return file;
        }
        finally {
            if (!successful) {
                FileUtils.delete(tmpFile);
            }
        }
    }

    public static File mkdir(File directory) throws IOException {
        if (!directory.mkdir()) {
            throw new IOException("Unable to create directory: " + directory.getPath());
        }
        return directory;
    }

    public static File mkdirs(File directory) throws IOException {
        if (!directory.mkdirs()) {
            throw new IOException("Unable to create directory or one of its parents: " + directory.getPath());
        }
        return directory;
    }

    public static File checkIsDirectory(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException("Not a directory: " + directory.getPath());
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        try {
            long bytes;
            long modified = from.lastModified();
            FileOutputStream out = new FileOutputStream(to);
            try {
                bytes = IoUtils.copy(in, out);
            }
            finally {
                ((OutputStream)out).close();
            }
            if (modified != 0L) {
                to.setLastModified(modified);
            }
            long l = bytes;
            return l;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File from, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(from);
        try {
            long l = IoUtils.copy(in, out);
            return l;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File from, Writer out) throws IOException {
        FileReader in = new FileReader(from);
        try {
            long l = IoUtils.copy((Reader)in, out);
            return l;
        }
        finally {
            ((Reader)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File from, Appendable out) throws IOException {
        FileReader in = new FileReader(from);
        try {
            long l = IoUtils.copy((Reader)in, out);
            return l;
        }
        finally {
            ((Reader)in).close();
        }
    }

    public static void copyRecursive(File from, File to) throws IOException {
        FileUtils.copyRecursive(from, to, null);
    }

    public static void copyRecursive(File from, File to, FileFilter fileFilter) throws IOException {
        if (fileFilter == null || fileFilter.accept(from)) {
            if (from.isDirectory()) {
                if (to.exists()) {
                    throw new IOException("Directory exists: " + to);
                }
                long modified = from.lastModified();
                FileUtils.mkdir(to);
                String[] list = from.list();
                if (list != null) {
                    for (String child : list) {
                        FileUtils.copyRecursive(new File(from, child), new File(to, child), fileFilter);
                    }
                }
                if (modified != 0L) {
                    to.setLastModified(modified);
                }
            } else if (from.isFile()) {
                if (to.exists()) {
                    throw new IOException("File exists: " + to);
                }
                FileUtils.copy(from, to);
            } else {
                throw new IOException("Neither directory not file: " + to);
            }
        }
    }

    public static String getExtension(String path) {
        int pos = path.lastIndexOf(46);
        if (pos < 1) {
            return "";
        }
        int pos2 = path.indexOf(47, pos + 1);
        if (pos2 != -1) {
            return "";
        }
        return path.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(URL url, String urlEncoding, boolean deleteOnExit) throws IOException {
        File file;
        String path;
        if ("file".equalsIgnoreCase(url.getProtocol()) && (path = url.getFile()).length() > 0 && (file = new File(URLDecoder.decode(path, urlEncoding).replace('/', File.separatorChar))).exists() && file.isFile()) {
            return file;
        }
        File file2 = File.createTempFile("url", null);
        boolean successful = false;
        try {
            if (deleteOnExit) {
                file2.deleteOnExit();
            }
            InputStream in = url.openStream();
            try {
                FileOutputStream out = new FileOutputStream(file2);
                try {
                    IoUtils.copy(in, out);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
            successful = true;
            File file3 = file2;
            return file3;
        }
        finally {
            if (!successful) {
                FileUtils.delete(file2);
            }
        }
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Unable to atomically rename \"" + from + "\" to \"" + to + '\"');
        }
    }

    public static void renameAllowNonAtomic(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            int NUM_TRIES = 10;
            for (int attempt = 1; attempt <= 10 && (to.exists() && !to.delete() || !from.renameTo(to)); ++attempt) {
                if (attempt == 10) {
                    throw new IOException("Unable to non-atomically rename \"" + from + "\" to \"" + to + '\"');
                }
                try {
                    Thread.sleep(4096L);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    InterruptedIOException ioErr = new InterruptedIOException();
                    ioErr.initCause(e2);
                    throw ioErr;
                }
            }
        }
    }

    public static String readFileAsString(File file) throws IOException {
        return FileUtils.readFileAsString(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file, Charset charset) throws IOException {
        long len = file.length();
        StringBuilder SB = len > 0L && len <= Integer.MAX_VALUE ? new StringBuilder((int)len) : new StringBuilder();
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), charset);
        try {
            char[] buff = BufferManager.getChars();
            try {
                int numChars;
                while ((numChars = ((Reader)in).read(buff, 0, 4096)) != -1) {
                    SB.append(buff, 0, numChars);
                }
            }
            finally {
                BufferManager.release(buff, false);
            }
        }
        finally {
            ((Reader)in).close();
        }
        return SB.toString();
    }
}

