/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.BufferedEncoder;
import com.aoindustries.encoding.EncodingContext;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInXhtmlEncoder;
import java.io.IOException;

public class UrlInXhtmlEncoder
extends BufferedEncoder {
    private final EncodingContext context;

    public UrlInXhtmlEncoder(EncodingContext context) {
        super(128);
        this.context = context;
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.URL || inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML;
    }

    @Override
    protected void writeSuffix(StringBuilder buffer, Appendable out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(this.context.encodeURL(buffer.toString()), out);
    }
}

