/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder;
import com.aoindustries.encoding.JavaScriptInXhtmlEncoder;
import com.aoindustries.encoding.TextInJavaScriptEncoder;
import java.io.IOException;

public class NewEncodingUtils {
    static final String EOL;
    static final String BR_EOL;
    static final char[] hexChars;
    private static final int ENCODE_RANGE_1_START = 0;
    private static final int ENCODE_RANGE_1_END = 32;
    private static final String[] javaScriptUnicodeEscapeStrings1;
    private static final int ENCODE_RANGE_2_START = 55296;
    private static final int ENCODE_RANGE_2_END = 57344;
    private static final String[] javaScriptUnicodeEscapeStrings2;
    private static final int ENCODE_RANGE_3_START = 65534;
    private static final int ENCODE_RANGE_3_END = 65536;
    private static final String[] javaScriptUnicodeEscapeStrings3;

    private NewEncodingUtils() {
    }

    static char getHex(int value) {
        return hexChars[value & 0xF];
    }

    static String getJavaScriptUnicodeEscapeString(char ch) {
        char chInt = ch;
        if (chInt >= '\u0000' && chInt < ' ') {
            return javaScriptUnicodeEscapeStrings1[chInt - '\u0000'];
        }
        if (chInt >= '\ud800' && chInt < '\ue000') {
            return javaScriptUnicodeEscapeStrings2[chInt - 55296];
        }
        if (chInt >= '\ufffe' && chInt < '\u10000') {
            return javaScriptUnicodeEscapeStrings3[chInt - 65534];
        }
        return null;
    }

    public static void encodeTextInJavaScriptInXhtml(String text, Appendable out) throws IOException {
        StringBuilder javascript = new StringBuilder(text.length());
        TextInJavaScriptEncoder.encodeTextInJavaScript(text, (Appendable)javascript);
        JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(javascript, out);
    }

    public static void encodeTextInJavaScriptInXhtmlAttribute(String text, Appendable out) throws IOException {
        StringBuilder javascript = new StringBuilder(text.length());
        TextInJavaScriptEncoder.encodeTextInJavaScript(text, (Appendable)javascript);
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(javascript, out);
    }

    public static String getTextInJavaScriptInXhtmlAttribute(String text) throws IOException {
        StringBuilder xhtml = new StringBuilder(text.length());
        NewEncodingUtils.encodeTextInJavaScriptInXhtmlAttribute(text, xhtml);
        return xhtml.toString();
    }

    static {
        int ch;
        EOL = System.getProperty("line.separator");
        BR_EOL = "<br />" + EOL;
        hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        javaScriptUnicodeEscapeStrings1 = new String[32];
        javaScriptUnicodeEscapeStrings2 = new String[2048];
        javaScriptUnicodeEscapeStrings3 = new String[2];
        for (ch = 0; ch < 32; ++ch) {
            NewEncodingUtils.javaScriptUnicodeEscapeStrings1[ch - 0] = "\\u" + NewEncodingUtils.getHex(ch >>> 12) + NewEncodingUtils.getHex(ch >>> 8) + NewEncodingUtils.getHex(ch >>> 4) + NewEncodingUtils.getHex(ch);
        }
        for (ch = 55296; ch < 57344; ++ch) {
            NewEncodingUtils.javaScriptUnicodeEscapeStrings2[ch - 55296] = "\\u" + NewEncodingUtils.getHex(ch >>> 12) + NewEncodingUtils.getHex(ch >>> 8) + NewEncodingUtils.getHex(ch >>> 4) + NewEncodingUtils.getHex(ch);
        }
        for (ch = 65534; ch < 65536; ++ch) {
            NewEncodingUtils.javaScriptUnicodeEscapeStrings3[ch - 65534] = "\\u" + NewEncodingUtils.getHex(ch >>> 12) + NewEncodingUtils.getHex(ch >>> 8) + NewEncodingUtils.getHex(ch >>> 4) + NewEncodingUtils.getHex(ch);
        }
    }
}

