/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.ApplicationResources;
import com.aoindustries.encoding.JavaScriptValidator;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextValidator;
import com.aoindustries.encoding.UrlValidator;
import com.aoindustries.encoding.ValidMediaFilter;
import com.aoindustries.encoding.XhtmlAttributeValidator;
import com.aoindustries.encoding.XhtmlValidator;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class MediaValidator
extends FilterWriter
implements ValidMediaFilter {
    public static MediaValidator getMediaValidator(MediaType contentType, Writer out) throws MediaException {
        MediaValidator inputValidator;
        if (out instanceof MediaValidator && (inputValidator = (MediaValidator)out).isValidatingMediaInputType(contentType)) {
            return inputValidator;
        }
        switch (contentType) {
            case JAVASCRIPT: 
            case JSON: 
            case LD_JSON: {
                return new JavaScriptValidator(out, contentType);
            }
            case TEXT: {
                return new TextValidator(out);
            }
            case URL: {
                return new UrlValidator(out);
            }
            case XHTML: {
                return new XhtmlValidator(out);
            }
            case XHTML_ATTRIBUTE: {
                return new XhtmlAttributeValidator(out);
            }
        }
        throw new MediaException(ApplicationResources.accessor.getMessage("MediaValidator.unableToFindValidator", new Object[]{contentType.getContentType()}));
    }

    protected MediaValidator(Writer out) {
        super(out);
    }

    public Writer getOut() {
        return this.out;
    }

    public abstract boolean canSkipValidation(MediaType var1);

    @Override
    public MediaValidator append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    public MediaValidator append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public MediaValidator append(char c) throws IOException {
        this.out.append(c);
        return this;
    }
}

