/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.ApplicationResources;
import com.aoindustries.encoding.EncodingContext;
import com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder;
import com.aoindustries.encoding.JavaScriptInXhtmlEncoder;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.TextInJavaScriptEncoder;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.encoding.TextInXhtmlEncoder;
import com.aoindustries.encoding.UrlInJavaScriptEncoder;
import com.aoindustries.encoding.UrlInXhtmlAttributeEncoder;
import com.aoindustries.encoding.UrlInXhtmlEncoder;
import com.aoindustries.encoding.ValidMediaFilter;
import com.aoindustries.io.Encoder;
import java.io.IOException;
import java.io.Writer;

public abstract class MediaEncoder
implements Encoder,
ValidMediaFilter {
    public static MediaEncoder getInstance(EncodingContext context, MediaType contentType, MediaType containerType) throws MediaException {
        MediaEncoder encoder;
        block0 : switch (contentType) {
            case JAVASCRIPT: {
                switch (containerType) {
                    case JAVASCRIPT: 
                    case JSON: 
                    case LD_JSON: {
                        return null;
                    }
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        encoder = JavaScriptInXhtmlEncoder.javaScriptInXhtmlEncoder;
                        break block0;
                    }
                    case XHTML_ATTRIBUTE: {
                        encoder = JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder;
                        break block0;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case JSON: {
                switch (containerType) {
                    case JAVASCRIPT: 
                    case JSON: 
                    case LD_JSON: {
                        return null;
                    }
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        encoder = JavaScriptInXhtmlEncoder.jsonInXhtmlEncoder;
                        break block0;
                    }
                    case XHTML_ATTRIBUTE: {
                        encoder = JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder;
                        break block0;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case LD_JSON: {
                switch (containerType) {
                    case JAVASCRIPT: 
                    case JSON: 
                    case LD_JSON: {
                        return null;
                    }
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        encoder = JavaScriptInXhtmlEncoder.ldJsonInXhtmlEncoder;
                        break block0;
                    }
                    case XHTML_ATTRIBUTE: {
                        encoder = JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder;
                        break block0;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case TEXT: {
                switch (containerType) {
                    case JAVASCRIPT: {
                        encoder = TextInJavaScriptEncoder.textInJavaScriptEncoder;
                        break block0;
                    }
                    case JSON: {
                        encoder = TextInJavaScriptEncoder.textInJsonEncoder;
                        break block0;
                    }
                    case LD_JSON: {
                        encoder = TextInJavaScriptEncoder.textInLdJsonEncoder;
                        break block0;
                    }
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        encoder = TextInXhtmlEncoder.textInXhtmlEncoder;
                        break block0;
                    }
                    case XHTML_ATTRIBUTE: {
                        encoder = TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder;
                        break block0;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case URL: {
                switch (containerType) {
                    case JAVASCRIPT: 
                    case JSON: 
                    case LD_JSON: {
                        encoder = new UrlInJavaScriptEncoder(containerType, context);
                        break block0;
                    }
                    case TEXT: {
                        return null;
                    }
                    case URL: {
                        return null;
                    }
                    case XHTML: {
                        encoder = new UrlInXhtmlEncoder(context);
                        break block0;
                    }
                    case XHTML_ATTRIBUTE: {
                        encoder = new UrlInXhtmlAttributeEncoder(context);
                        break block0;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case XHTML: {
                switch (containerType) {
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        return null;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            case XHTML_ATTRIBUTE: {
                switch (containerType) {
                    case TEXT: {
                        return null;
                    }
                    case XHTML: {
                        return null;
                    }
                    case XHTML_ATTRIBUTE: {
                        return null;
                    }
                }
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
            default: {
                throw new MediaException(ApplicationResources.accessor.getMessage("MediaWriter.unableToFindEncoder", new Object[]{contentType.getContentType(), containerType.getContentType()}));
            }
        }
        assert (encoder.getValidMediaOutputType() == containerType) : "encoder.getValidMediaOutputType()!=containerType: " + (Object)((Object)encoder.getValidMediaOutputType()) + "!=" + (Object)((Object)containerType);
        assert (encoder.isValidatingMediaInputType(contentType)) : "encoder=" + encoder.getClass().getName() + " is not a validator for contentType=" + (Object)((Object)contentType);
        return encoder;
    }

    protected MediaEncoder() {
    }

    public void writePrefixTo(Appendable out) throws IOException {
    }

    public abstract void write(int var1, Writer var2) throws IOException;

    public abstract void write(char[] var1, Writer var2) throws IOException;

    public abstract void write(char[] var1, int var2, int var3, Writer var4) throws IOException;

    public abstract void write(String var1, Writer var2) throws IOException;

    public abstract void write(String var1, int var2, int var3, Writer var4) throws IOException;

    public abstract MediaEncoder append(char var1, Appendable var2) throws IOException;

    public abstract MediaEncoder append(CharSequence var1, Appendable var2) throws IOException;

    public abstract MediaEncoder append(CharSequence var1, int var2, int var3, Appendable var4) throws IOException;

    public void writeSuffixTo(Appendable out) throws IOException {
    }
}

