/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.Coercion;
import com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder;
import com.aoindustries.encoding.JavaScriptInXhtmlEncoder;
import com.aoindustries.encoding.MediaWriter;
import com.aoindustries.encoding.TextInJavaScriptEncoder;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.encoding.TextInXhtmlEncoder;
import com.aoindustries.io.Writable;
import com.aoindustries.sql.SQLUtility;
import com.aoindustries.util.EncodingUtils;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import com.aoindustries.util.i18n.MarkupType;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;

public final class ChainWriter
implements Appendable,
Closeable {
    private final PrintWriter out;
    private final MediaWriter javaScriptInXhtmlAttributeWriter;
    private final MediaWriter javaScriptInXhtmlWriter;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ChainWriter(OutputStream out) {
        this(new PrintWriter(out));
    }

    public ChainWriter(OutputStream out, boolean autoFlush) {
        this(new PrintWriter(out, autoFlush));
    }

    public ChainWriter(PrintWriter out) {
        this.out = out;
        this.javaScriptInXhtmlAttributeWriter = new MediaWriter(JavaScriptInXhtmlAttributeEncoder.javaScriptInXhtmlAttributeEncoder, out);
        this.javaScriptInXhtmlWriter = new MediaWriter(JavaScriptInXhtmlEncoder.javaScriptInXhtmlEncoder, out);
    }

    public ChainWriter(Writer out) {
        this(new PrintWriter(out));
    }

    public ChainWriter(Writer out, boolean autoFlush) {
        this(new PrintWriter(out, autoFlush));
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public ChainWriter flush() throws IOException {
        if (this.out.checkError()) {
            throw new IOException("Error occured on underlying PrintWriter");
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.out.checkError()) {
            throw new IOException("Error occured on underlying PrintWriter");
        }
    }

    public ChainWriter write(int c) {
        this.out.write(c);
        return this;
    }

    public ChainWriter write(char[] buf, int off, int len) {
        this.out.write(buf, off, len);
        return this;
    }

    public ChainWriter write(char[] buf) {
        this.out.write(buf);
        return this;
    }

    public ChainWriter write(String s, int off, int len) {
        this.out.write(s, off, len);
        return this;
    }

    public ChainWriter write(String s) {
        this.out.write(s);
        return this;
    }

    public ChainWriter print(boolean b) {
        this.out.print(b);
        return this;
    }

    public ChainWriter print(char c) {
        this.out.print(c);
        return this;
    }

    public ChainWriter print(int i) {
        this.out.print(i);
        return this;
    }

    public ChainWriter print(long l) {
        this.out.print(l);
        return this;
    }

    public ChainWriter print(float f) {
        this.out.print(f);
        return this;
    }

    public ChainWriter print(double d) {
        this.out.print(d);
        return this;
    }

    public ChainWriter print(char[] s) {
        this.out.print(s);
        return this;
    }

    public ChainWriter print(String s) {
        this.out.print(s);
        return this;
    }

    public ChainWriter print(Object obj) {
        this.out.print(obj);
        return this;
    }

    public ChainWriter println() {
        this.out.println();
        return this;
    }

    public ChainWriter println(boolean x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(char x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(int x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(long x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(float x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(double x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(char[] x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(String x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter println(Object x) {
        this.out.println(x);
        return this;
    }

    public ChainWriter printf(String format, Object ... args) {
        this.out.printf(format, args);
        return this;
    }

    public ChainWriter printf(Locale l, String format, Object ... args) {
        this.out.printf(l, format, args);
        return this;
    }

    public ChainWriter format(String format, Object ... args) {
        this.out.format(format, args);
        return this;
    }

    public ChainWriter format(Locale l, String format, Object ... args) {
        this.out.format(l, format, args);
        return this;
    }

    @Override
    public ChainWriter append(CharSequence csq) {
        this.out.append(csq);
        return this;
    }

    @Override
    public ChainWriter append(CharSequence csq, int start, int end) {
        this.out.append(csq, start, end);
        return this;
    }

    @Override
    public ChainWriter append(char c) {
        this.out.append(c);
        return this;
    }

    public ChainWriter encodeXmlAttribute(Object value) throws IOException {
        Coercion.write(value, TextInXhtmlAttributeEncoder.textInXhtmlAttributeEncoder, this.out);
        return this;
    }

    public ChainWriter encodeXhtml(Object value) throws IOException {
        if (value != null) {
            if (value instanceof Writable && !((Writable)value).isFastToString()) {
                Coercion.write(value, TextInXhtmlEncoder.textInXhtmlEncoder, this.out);
            } else {
                String str = Coercion.toString(value);
                BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
                BundleLookupMarkup lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(str) : null;
                if (lookupMarkup != null) {
                    lookupMarkup.appendPrefixTo(MarkupType.XHTML, (Appendable)this.out);
                }
                TextInXhtmlEncoder.textInXhtmlEncoder.write(str, (Writer)this.out);
                if (lookupMarkup != null) {
                    lookupMarkup.appendSuffixTo(MarkupType.XHTML, (Appendable)this.out);
                }
            }
        }
        return this;
    }

    @Deprecated
    public ChainWriter encodeHtml(Object value) throws IOException {
        EncodingUtils.encodeHtml((Object)value, (boolean)true, (boolean)true, (Appendable)this.out);
        return this;
    }

    @Deprecated
    public ChainWriter encodeHtml(Object value, boolean make_br, boolean make_nbsp) throws IOException {
        EncodingUtils.encodeHtml((Object)value, (boolean)make_br, (boolean)make_nbsp, (Appendable)this.out);
        return this;
    }

    @Deprecated
    public ChainWriter encodeJavaScriptString(String S) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(S, (Appendable)this.out);
        return this;
    }

    public ChainWriter encodeJavaScriptStringInXmlAttribute(Object value) throws IOException {
        if (value instanceof Writable && !((Writable)value).isFastToString()) {
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writePrefixTo((Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
            Coercion.write(value, TextInJavaScriptEncoder.textInJavaScriptEncoder, (Writer)((Object)this.javaScriptInXhtmlAttributeWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writeSuffixTo((Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
        } else {
            String str = Coercion.toString(value);
            BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
            BundleLookupMarkup lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(str) : null;
            if (lookupMarkup != null) {
                lookupMarkup.appendPrefixTo(MarkupType.JAVASCRIPT, (Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
            }
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writePrefixTo((Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.write(str, (Writer)((Object)this.javaScriptInXhtmlAttributeWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writeSuffixTo((Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
            if (lookupMarkup != null) {
                lookupMarkup.appendSuffixTo(MarkupType.JAVASCRIPT, (Appendable)((Object)this.javaScriptInXhtmlAttributeWriter));
            }
        }
        return this;
    }

    public ChainWriter encodeJavaScriptStringInXhtml(Object value) throws IOException {
        if (value instanceof Writable && !((Writable)value).isFastToString()) {
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writePrefixTo((Appendable)((Object)this.javaScriptInXhtmlWriter));
            Coercion.write(value, TextInJavaScriptEncoder.textInJavaScriptEncoder, (Writer)((Object)this.javaScriptInXhtmlWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writeSuffixTo((Appendable)((Object)this.javaScriptInXhtmlWriter));
        } else {
            String str = Coercion.toString(value);
            BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext((boolean)false);
            BundleLookupMarkup lookupMarkup = threadContext != null ? threadContext.getLookupMarkup(str) : null;
            if (lookupMarkup != null) {
                lookupMarkup.appendPrefixTo(MarkupType.JAVASCRIPT, (Appendable)((Object)this.javaScriptInXhtmlWriter));
            }
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writePrefixTo((Appendable)((Object)this.javaScriptInXhtmlWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.write(str, (Writer)((Object)this.javaScriptInXhtmlWriter));
            TextInJavaScriptEncoder.textInJavaScriptEncoder.writeSuffixTo((Appendable)((Object)this.javaScriptInXhtmlWriter));
            if (lookupMarkup != null) {
                lookupMarkup.appendSuffixTo(MarkupType.JAVASCRIPT, (Appendable)((Object)this.javaScriptInXhtmlWriter));
            }
        }
        return this;
    }

    @Deprecated
    public ChainWriter printEU(String value) {
        int len = value.length();
        for (int c = 0; c < len; ++c) {
            char ch = value.charAt(c);
            if (ch == ' ') {
                this.out.print('+');
                continue;
            }
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                this.out.print(ch);
                continue;
            }
            this.out.print('%');
            this.out.print(ChainWriter.getHex(ch >>> 4));
            this.out.print(ChainWriter.getHex(ch));
        }
        return this;
    }

    private static char getHex(int value) {
        return hexChars[value & 0xF];
    }

    public static void writeHtmlColor(int color, Appendable out) throws IOException {
        out.append('#');
        out.append(ChainWriter.getHex(color >>> 20));
        out.append(ChainWriter.getHex(color >>> 16));
        out.append(ChainWriter.getHex(color >>> 12));
        out.append(ChainWriter.getHex(color >>> 8));
        out.append(ChainWriter.getHex(color >>> 4));
        out.append(ChainWriter.getHex(color));
    }

    public ChainWriter printHTMLColor(int color) throws IOException {
        return this.writeHtmlColor(color);
    }

    public ChainWriter writeHtmlColor(int color) throws IOException {
        ChainWriter.writeHtmlColor(color, this.out);
        return this;
    }

    public static void writeHtmlImagePreloadJavaScript(String url, Appendable out) throws IOException {
        out.append("<script type='text/javascript'>\n  var img=new Image();\n  img.src=\"");
        StringBuilder javascript = new StringBuilder(url.length());
        TextInJavaScriptEncoder.encodeTextInJavaScript(url, (Appendable)javascript);
        JavaScriptInXhtmlAttributeEncoder.encodeJavaScriptInXhtmlAttribute(javascript, out);
        out.append("\";\n</script>");
    }

    public ChainWriter printImagePreloadJS(String url) throws IOException {
        return this.writeHtmlImagePreloadJavaScript(url);
    }

    public ChainWriter writeHtmlImagePreloadJavaScript(String url) throws IOException {
        ChainWriter.writeHtmlImagePreloadJavaScript(url, this.out);
        return this;
    }

    public static void writeDateJavaScript(Date date, Sequence sequence, Appendable out, Appendable scriptOut) throws IOException {
        if (date == null) {
            out.append("&#160;");
        } else {
            String dateString = SQLUtility.getDate((long)date.getTime());
            long id = sequence.getNextSequenceValue();
            String idString = Long.toString(id);
            out.append("<span id=\"chainWriterDate");
            out.append(idString);
            out.append("\">");
            TextInXhtmlEncoder.encodeTextInXhtml(dateString, out);
            out.append("</span>");
            if (id == 1L) {
                scriptOut.append("  function chainWriterUpdateDate(id, millis, serverValue) {\n    if(document.getElementById) {\n      var date=new Date(millis);\n      var clientValue=date.getFullYear() + \"-\";\n      var month=date.getMonth()+1;\n      if(month<10) clientValue+=\"0\";\n      clientValue+=month+\"-\";\n      var day=date.getDate();\n      if(day<10) clientValue+=\"0\";\n      clientValue+=day;\n      if(clientValue!=serverValue) document.getElementById(\"chainWriterDate\"+id).firstChild.nodeValue=clientValue;\n    }\n  }\n");
            }
            scriptOut.append("  chainWriterUpdateDate(");
            scriptOut.append(idString);
            scriptOut.append(", ");
            scriptOut.append(Long.toString(date.getTime()));
            scriptOut.append(", \"");
            JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(dateString, scriptOut);
            scriptOut.append("\");\n");
        }
    }

    @Deprecated
    public ChainWriter printDateJS(long date, Sequence sequence, Appendable scriptOut) throws IOException {
        return this.writeDateJavaScript(date == -1L ? null : new Date(date), sequence, scriptOut);
    }

    public ChainWriter writeDateJavaScript(Date date, Sequence sequence, Appendable scriptOut) throws IOException {
        ChainWriter.writeDateJavaScript(date, sequence, this.out, scriptOut);
        return this;
    }

    public static void writeDateTimeJavaScript(Date date, Sequence sequence, Appendable out, Appendable scriptOut) throws IOException {
        if (date == null) {
            out.append("&#160;");
        } else {
            String dateTimeString = SQLUtility.getDateTime((long)date.getTime());
            long id = sequence.getNextSequenceValue();
            String idString = Long.toString(id);
            out.append("<span id=\"chainWriterDateTime");
            out.append(idString);
            out.append("\">");
            TextInXhtmlEncoder.encodeTextInXhtml(dateTimeString, out);
            out.append("</span>");
            if (id == 1L) {
                scriptOut.append("  function chainWriterUpdateDateTime(id, millis, serverValue) {\n    if(document.getElementById) {\n      var date=new Date(millis);\n      var clientValue=date.getFullYear() + \"-\";\n      var month=date.getMonth()+1;\n      if(month<10) clientValue+=\"0\";\n      clientValue+=month+\"-\";\n      var day=date.getDate();\n      if(day<10) clientValue+=\"0\";\n      clientValue+=day+\" \";\n      var hour=date.getHours();\n      if(hour<10) clientValue+=\"0\";\n      clientValue+=hour+\":\";\n      var minute=date.getMinutes();\n      if(minute<10) clientValue+=\"0\";\n      clientValue+=minute+\":\";\n      var second=date.getSeconds();\n      if(second<10) clientValue+=\"0\";\n      clientValue+=second;\n      if(clientValue!=serverValue) document.getElementById(\"chainWriterDateTime\"+id).firstChild.nodeValue=clientValue;\n    }\n  }\n");
            }
            scriptOut.append("  chainWriterUpdateDateTime(");
            scriptOut.append(idString);
            scriptOut.append(", ");
            scriptOut.append(Long.toString(date.getTime()));
            scriptOut.append(", \"");
            JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(dateTimeString, scriptOut);
            scriptOut.append("\");\n");
        }
    }

    @Deprecated
    public ChainWriter printDateTimeJS(long date, Sequence sequence, Appendable scriptOut) throws IOException {
        return this.writeDateTimeJavaScript(date == -1L ? null : new Date(date), sequence, scriptOut);
    }

    public ChainWriter writeDateTimeJavaScript(Date date, Sequence sequence, Appendable scriptOut) throws IOException {
        ChainWriter.writeDateTimeJavaScript(date, sequence, this.out, scriptOut);
        return this;
    }

    public static void writeTimeJavaScript(Date date, Sequence sequence, Appendable out, Appendable scriptOut) throws IOException {
        if (date == null) {
            out.append("&#160;");
        } else {
            String timeString = SQLUtility.getTime((long)date.getTime());
            long id = sequence.getNextSequenceValue();
            String idString = Long.toString(id);
            out.append("<span id=\"chainWriterTime");
            out.append(idString);
            out.append("\">");
            TextInXhtmlEncoder.encodeTextInXhtml(timeString, out);
            out.append("</span>");
            if (id == 1L) {
                scriptOut.append("  function chainWriterUpdateTime(id, millis, serverValue) {\n    if(document.getElementById) {\n      var date=new Date(millis);\n      var hour=date.getHours();\n      var clientValue=(hour<10)?\"0\":\"\";\n      clientValue+=hour+\":\";\n      var minute=date.getMinutes();\n      if(minute<10) clientValue+=\"0\";\n      clientValue+=minute+\":\";\n      var second=date.getSeconds();\n      if(second<10) clientValue+=\"0\";\n      clientValue+=second;\n      if(clientValue!=serverValue) document.getElementById(\"chainWriterTime\"+id).firstChild.nodeValue=clientValue;\n    }\n  }\n");
            }
            scriptOut.append("  chainWriterUpdateTime(");
            scriptOut.append(idString);
            scriptOut.append(", ");
            scriptOut.append(Long.toString(date.getTime()));
            scriptOut.append(", \"");
            JavaScriptInXhtmlEncoder.encodeJavaScriptInXhtml(timeString, scriptOut);
            scriptOut.append("\");\n");
        }
    }

    @Deprecated
    public ChainWriter printTimeJS(long date, Sequence sequence, Appendable scriptOut) throws IOException {
        return this.writeTimeJavaScript(date == -1L ? null : new Date(date), sequence, scriptOut);
    }

    public ChainWriter writeTimeJavaScript(Date date, Sequence sequence, Appendable scriptOut) throws IOException {
        ChainWriter.writeTimeJavaScript(date, sequence, this.out, scriptOut);
        return this;
    }
}

