/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class RepeatableCipherInputStream
extends SdkFilterInputStream {
    private CipherFactory cipherFactory;
    private InputStream unencryptedDataStream;
    private boolean hasBeenAccessed;

    public RepeatableCipherInputStream(InputStream input, CipherFactory cipherFactory) {
        super(RepeatableCipherInputStream.createCipherInputStream(input, cipherFactory));
        this.unencryptedDataStream = input;
        this.cipherFactory = cipherFactory;
    }

    public boolean markSupported() {
        return this.unencryptedDataStream.markSupported();
    }

    public void mark(int readlimit) {
        if (this.hasBeenAccessed) {
            throw new UnsupportedOperationException("Marking is only supported before your first call to read or skip.");
        }
        this.unencryptedDataStream.mark(readlimit);
    }

    public void reset() throws IOException {
        this.unencryptedDataStream.reset();
        this.in = RepeatableCipherInputStream.createCipherInputStream(this.unencryptedDataStream, this.cipherFactory);
        this.hasBeenAccessed = false;
    }

    public int read() throws IOException {
        this.hasBeenAccessed = true;
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.hasBeenAccessed = true;
        return super.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        this.hasBeenAccessed = true;
        return super.skip(n);
    }

    private static CipherInputStream createCipherInputStream(InputStream input, CipherFactory cipherFactory) {
        Cipher cipher = cipherFactory.createCipher();
        return new CipherInputStream(input, cipher);
    }
}

