/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchWriteItemRequestMarshaller
implements Marshaller<Request<BatchWriteItemRequest>, BatchWriteItemRequest> {
    @Override
    public Request<BatchWriteItemRequest> marshall(BatchWriteItemRequest batchWriteItemRequest) {
        if (batchWriteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchWriteItemRequest> request = new DefaultRequest<BatchWriteItemRequest>(batchWriteItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchWriteItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchWriteItemRequest.getRequestItems() != null) {
                jsonWriter.key("RequestItems");
                jsonWriter.object();
                for (Map.Entry<String, List<WriteRequest>> requestItemsListValue : batchWriteItemRequest.getRequestItems().entrySet()) {
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.key(requestItemsListValue.getKey());
                    jsonWriter.array();
                    for (WriteRequest valueListValue : requestItemsListValue.getValue()) {
                        DeleteRequest deleteRequest;
                        if (valueListValue == null) continue;
                        jsonWriter.object();
                        PutRequest putRequest = valueListValue.getPutRequest();
                        if (putRequest != null) {
                            jsonWriter.key("PutRequest");
                            jsonWriter.object();
                            if (putRequest.getItem() != null) {
                                jsonWriter.key("Item");
                                jsonWriter.object();
                                for (Map.Entry<String, AttributeValue> itemListValue : putRequest.getItem().entrySet()) {
                                    ListWithAutoConstructFlag bSList;
                                    ListWithAutoConstructFlag nSList;
                                    ListWithAutoConstructFlag sSList;
                                    if (itemListValue.getValue() == null) continue;
                                    jsonWriter.key(itemListValue.getKey());
                                    jsonWriter.object();
                                    if (itemListValue.getValue().getS() != null) {
                                        jsonWriter.key("S").value(itemListValue.getValue().getS());
                                    }
                                    if (itemListValue.getValue().getN() != null) {
                                        jsonWriter.key("N").value(itemListValue.getValue().getN());
                                    }
                                    if (itemListValue.getValue().getB() != null) {
                                        jsonWriter.key("B").value(itemListValue.getValue().getB());
                                    }
                                    if (!((sSList = (ListWithAutoConstructFlag)itemListValue.getValue().getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                                        jsonWriter.key("SS");
                                        jsonWriter.array();
                                        for (String sSListValue : sSList) {
                                            if (sSListValue == null) continue;
                                            jsonWriter.value(sSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    if (!((nSList = (ListWithAutoConstructFlag)itemListValue.getValue().getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                                        jsonWriter.key("NS");
                                        jsonWriter.array();
                                        for (String nSListValue : nSList) {
                                            if (nSListValue == null) continue;
                                            jsonWriter.value(nSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    if (!((bSList = (ListWithAutoConstructFlag)itemListValue.getValue().getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                                        jsonWriter.key("BS");
                                        jsonWriter.array();
                                        for (ByteBuffer bSListValue : bSList) {
                                            if (bSListValue == null) continue;
                                            jsonWriter.value(bSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if ((deleteRequest = valueListValue.getDeleteRequest()) != null) {
                            jsonWriter.key("DeleteRequest");
                            jsonWriter.object();
                            if (deleteRequest.getKey() != null) {
                                jsonWriter.key("Key");
                                jsonWriter.object();
                                for (Map.Entry<String, AttributeValue> keyListValue : deleteRequest.getKey().entrySet()) {
                                    ListWithAutoConstructFlag bSList;
                                    ListWithAutoConstructFlag nSList;
                                    ListWithAutoConstructFlag sSList;
                                    if (keyListValue.getValue() == null) continue;
                                    jsonWriter.key(keyListValue.getKey());
                                    jsonWriter.object();
                                    if (keyListValue.getValue().getS() != null) {
                                        jsonWriter.key("S").value(keyListValue.getValue().getS());
                                    }
                                    if (keyListValue.getValue().getN() != null) {
                                        jsonWriter.key("N").value(keyListValue.getValue().getN());
                                    }
                                    if (keyListValue.getValue().getB() != null) {
                                        jsonWriter.key("B").value(keyListValue.getValue().getB());
                                    }
                                    if (!((sSList = (ListWithAutoConstructFlag)keyListValue.getValue().getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                                        jsonWriter.key("SS");
                                        jsonWriter.array();
                                        for (String sSListValue : sSList) {
                                            if (sSListValue == null) continue;
                                            jsonWriter.value(sSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    if (!((nSList = (ListWithAutoConstructFlag)keyListValue.getValue().getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                                        jsonWriter.key("NS");
                                        jsonWriter.array();
                                        for (String nSListValue : nSList) {
                                            if (nSListValue == null) continue;
                                            jsonWriter.value(nSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    if (!((bSList = (ListWithAutoConstructFlag)keyListValue.getValue().getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                                        jsonWriter.key("BS");
                                        jsonWriter.array();
                                        for (ByteBuffer bSListValue : bSList) {
                                            if (bSListValue == null) continue;
                                            jsonWriter.value(bSListValue);
                                        }
                                        jsonWriter.endArray();
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (batchWriteItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(batchWriteItemRequest.getReturnConsumedCapacity());
            }
            if (batchWriteItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(batchWriteItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

