/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.ClientConnectionRequestFactory;
import com.amazonaws.http.conn.Wrapped;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);
    private static final Class<?>[] interfaces = new Class[]{ClientConnectionManager.class, Wrapped.class};

    public static ClientConnectionManager wrap(ClientConnectionManager orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ClientConnectionManager orig;

        Handler(ClientConnectionManager real) {
            this.orig = real;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object ret = method.invoke((Object)this.orig, args);
                return ret instanceof ClientConnectionRequest ? ClientConnectionRequestFactory.wrap((ClientConnectionRequest)ret) : ret;
            }
            catch (InvocationTargetException e) {
                log.debug((Object)"", (Throwable)e);
                throw e.getCause();
            }
        }
    }
}

