/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPolicyWriter {
    public String writePolicyToString(Policy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Policy cannot be null");
        }
        StringWriter writer = new StringWriter();
        try {
            JSONWriter generator = new JSONWriter(writer);
            this.writePolicy(policy, generator);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            String message = "Unable to serialize policy to JSON string: " + e.getMessage();
            throw new IllegalArgumentException(message, e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    private void writePolicy(Policy policy, JSONWriter generator) throws JSONException, IOException {
        generator.object();
        generator.key("Version").value(policy.getVersion());
        if (policy.getId() != null) {
            generator.key("Id").value(policy.getId());
        }
        generator.key("Statement").array();
        for (Statement statement : policy.getStatements()) {
            generator.object();
            if (statement.getId() != null) {
                generator.key("Sid").value(statement.getId());
            }
            generator.key("Effect").value(statement.getEffect().toString());
            this.writePrincipals(statement, generator);
            this.writeActions(statement, generator);
            this.writeResources(statement, generator);
            this.writeConditions(statement, generator);
            generator.endObject();
        }
        generator.endArray();
        generator.endObject();
    }

    private void writeConditions(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Condition> conditions = statement.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return;
        }
        Map<String, List<Condition>> conditionsByType = this.sortConditionsByType(conditions);
        generator.key("Condition").object();
        for (Map.Entry<String, List<Condition>> entry : conditionsByType.entrySet()) {
            String conditionType = entry.getKey();
            generator.key(conditionType).object();
            this.writeConditions(entry.getValue(), generator);
            generator.endObject();
        }
        generator.endObject();
    }

    private void writeConditions(List<Condition> conditions, JSONWriter generator) throws IOException, JSONException {
        Map<String, List<String>> conditionValuesByKey = this.sortConditionsByKey(conditions);
        for (Map.Entry<String, List<String>> entry : conditionValuesByKey.entrySet()) {
            String conditionKey = entry.getKey();
            generator.key(conditionKey).array();
            for (String value : entry.getValue()) {
                generator.value(value);
            }
            generator.endArray();
        }
    }

    private Map<String, List<String>> sortConditionsByKey(List<Condition> conditions) {
        HashMap<String, List<String>> conditionValuesByConditionKey = new HashMap<String, List<String>>();
        for (Condition condition : conditions) {
            String key = condition.getConditionKey();
            List<String> values = condition.getValues();
            if (!conditionValuesByConditionKey.containsKey(key)) {
                conditionValuesByConditionKey.put(key, new ArrayList());
            }
            ((List)conditionValuesByConditionKey.get(key)).addAll(values);
        }
        return conditionValuesByConditionKey;
    }

    private Map<String, List<Condition>> sortConditionsByType(List<Condition> conditions) {
        HashMap<String, List<Condition>> conditionsByType = new HashMap<String, List<Condition>>();
        for (Condition condition : conditions) {
            String conditionType = condition.getType();
            if (conditionsByType.get(conditionType) == null) {
                conditionsByType.put(conditionType, new ArrayList());
            }
            ((List)conditionsByType.get(conditionType)).add(condition);
        }
        return conditionsByType;
    }

    private void writeResources(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Resource> resources = statement.getResources();
        if (resources == null || resources.isEmpty()) {
            return;
        }
        generator.key("Resource").array();
        for (Resource resource : resources) {
            generator.value(resource.getId());
        }
        generator.endArray();
    }

    private void writeActions(Statement statement, JSONWriter generator) throws IOException, JSONException {
        List<Action> actions = statement.getActions();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        generator.key("Action").array();
        for (Action action : actions) {
            generator.value(action.getActionName());
        }
        generator.endArray();
    }

    private void writePrincipals(Statement statement, JSONWriter generator) throws IOException, JSONException {
        boolean allAccessPrincipal = false;
        boolean allUserAccessPrincipal = false;
        boolean allServiceAccessPrincipal = false;
        boolean allFederatedAccessPrincipal = false;
        List<Principal> principals = statement.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            return;
        }
        HashMap<String, ArrayList<String>> principalContentsByScheme = new HashMap<String, ArrayList<String>>();
        for (Principal principal : principals) {
            ArrayList<String> principalValues;
            if (principal.equals(Principal.All)) {
                allAccessPrincipal = true;
            }
            if (principal.equals(Principal.AllUsers)) {
                allUserAccessPrincipal = true;
            }
            if (principal.equals(Principal.AllServices)) {
                allServiceAccessPrincipal = true;
            }
            if (principal.equals(Principal.AllWebProviders)) {
                allFederatedAccessPrincipal = true;
            }
            if ((principalValues = (ArrayList<String>)principalContentsByScheme.get(principal.getProvider())) == null) {
                principalValues = new ArrayList<String>();
                principalContentsByScheme.put(principal.getProvider(), principalValues);
            }
            principalValues.add(principal.getId());
        }
        if (allAccessPrincipal) {
            generator.key("Principal");
            generator.value("*");
            return;
        }
        generator.key("Principal").object();
        if (allUserAccessPrincipal) {
            principalContentsByScheme.remove("AWS");
            generator.key("AWS").value("*");
        }
        if (allServiceAccessPrincipal) {
            principalContentsByScheme.remove("Service");
            generator.key("Service");
            generator.value("*");
        }
        if (allFederatedAccessPrincipal) {
            principalContentsByScheme.remove("Federated");
            generator.key("Federated");
            generator.value("*");
        }
        for (Map.Entry entry : principalContentsByScheme.entrySet()) {
            String scheme = (String)entry.getKey();
            generator.key(scheme).array();
            for (String principalId : (List)entry.getValue()) {
                generator.value(principalId);
            }
            generator.endArray();
        }
        generator.endObject();
    }
}

