/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.common.utils.LoggerUtils;

public class RangeSpec {
    private static final String RANGE_PREFIX = "bytes=";
    private long start;
    private long end;
    private Type type;

    public RangeSpec() {
        this(0L, 0L, Type.NORMAL_RANGE);
    }

    public RangeSpec(long start, long end, Type type) {
        this.start = start;
        this.end = end;
        this.type = type;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public Type getType() {
        return this.type;
    }

    public static RangeSpec parse(long[] range) {
        if (range == null || range.length != 2) {
            LoggerUtils.getLogger().warn((Object)("Invalid range value " + range + ", ignore it and just get entire object"));
        }
        long start = range[0];
        long end = range[1];
        if (start < 0L && end < 0L || start > 0L && end > 0L && start > end) {
            LoggerUtils.getLogger().warn((Object)("Invalid range value [" + start + ", " + end + "], ignore it and just get entire object"));
        }
        RangeSpec rs = start < 0L ? new RangeSpec(-1L, end, Type.TO_END) : (end < 0L ? new RangeSpec(start, -1L, Type.START_TO) : new RangeSpec(start, end, Type.NORMAL_RANGE));
        return rs;
    }

    public String toString() {
        String formatted = null;
        switch (this.type) {
            case NORMAL_RANGE: {
                formatted = String.format("%s%d-%d", RANGE_PREFIX, this.start, this.end);
                break;
            }
            case START_TO: {
                formatted = String.format("%s%d-", RANGE_PREFIX, this.start);
                break;
            }
            case TO_END: {
                formatted = String.format("%s-%d", RANGE_PREFIX, this.end);
            }
        }
        return formatted;
    }

    public static enum Type {
        NORMAL_RANGE,
        START_TO,
        TO_END;

    }
}

