/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsConsumeMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import java.util.Properties;
import org.slf4j.Logger;

public class ONSConsumerAbstract
extends ONSClientAbstract {
    static final Logger log = ClientLoggerUtil.getClientLogger();
    final DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer(new OnsClientRPCHook(this.sessionCredentials));
    private static final int MAX_CACHED_MESSAGE_SIZE_IN_MIB = 2048;
    private static final int MIN_CACHED_MESSAGE_SIZE_IN_MIB = 16;
    private static final int MAX_CACHED_MESSAGE_AMOUNT = 50000;
    private static final int MIN_CACHED_MESSAGE_AMOUNT = 100;
    private int maxCachedMessageSizeInMiB = 512;
    private int maxCachedMessageAmount = 5000;

    public ONSConsumerAbstract(Properties properties) {
        super(properties);
        String msgTraceSwitch;
        String configuredCachedMessageSizeInMiB;
        String configuredCachedMessageAmount;
        String consumeTimeout;
        String consumerGroup = properties.getProperty("ConsumerId");
        if (null == consumerGroup) {
            throw new ONSClientException("ConsumerId property is null");
        }
        String maxReconsumeTimes = properties.getProperty("maxReconsumeTimes");
        if (!UtilAll.isBlank(maxReconsumeTimes)) {
            try {
                this.defaultMQPushConsumer.setMaxReconsumeTimes(Integer.parseInt(maxReconsumeTimes));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (!UtilAll.isBlank(consumeTimeout = properties.getProperty("consumeTimeout"))) {
            try {
                this.defaultMQPushConsumer.setConsumeTimeout(Integer.parseInt(consumeTimeout));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.defaultMQPushConsumer.setVipChannelEnabled(isVipChannelEnabled);
        this.defaultMQPushConsumer.setConsumerGroup(consumerGroup);
        this.defaultMQPushConsumer.setInstanceName(this.buildIntanceName());
        this.defaultMQPushConsumer.setNamesrvAddr(this.getNameServerAddr());
        String consumeThreadNums = properties.getProperty("ConsumeThreadNums");
        if (!UtilAll.isBlank(consumeThreadNums)) {
            this.defaultMQPushConsumer.setConsumeThreadMin(Integer.valueOf(consumeThreadNums));
            this.defaultMQPushConsumer.setConsumeThreadMax(Integer.valueOf(consumeThreadNums));
        }
        if (!UtilAll.isBlank(configuredCachedMessageAmount = properties.getProperty("maxCachedMessageAmount"))) {
            this.maxCachedMessageAmount = Math.min(50000, Integer.valueOf(configuredCachedMessageAmount));
            this.maxCachedMessageAmount = Math.max(100, this.maxCachedMessageAmount);
            this.defaultMQPushConsumer.setPullThresholdForTopic(this.maxCachedMessageAmount);
        }
        if (!UtilAll.isBlank(configuredCachedMessageSizeInMiB = properties.getProperty("maxCachedMessageSizeInMiB"))) {
            this.maxCachedMessageSizeInMiB = Math.min(2048, Integer.valueOf(configuredCachedMessageSizeInMiB));
            this.maxCachedMessageSizeInMiB = Math.max(16, this.maxCachedMessageSizeInMiB);
            this.defaultMQPushConsumer.setPullThresholdSizeForTopic(this.maxCachedMessageSizeInMiB);
        }
        if (!UtilAll.isBlank(msgTraceSwitch = properties.getProperty("MsgTraceSwitch")) && !Boolean.parseBoolean(msgTraceSwitch)) {
            log.info("MQ Client Disable the Trace Hook!");
        } else {
            try {
                Properties tempProperties = new Properties();
                tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
                tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
                tempProperties.put("MaxMsgSize", "128000");
                tempProperties.put("AsyncBufferSize", "2048");
                tempProperties.put("MaxBatchNum", "100");
                tempProperties.put("NAMESRV_ADDR", this.getNameServerAddr());
                tempProperties.put("InstanceName", this.buildIntanceName());
                this.traceDispatcher = new AsyncArrayDispatcher(tempProperties);
                this.traceDispatcher.start(this.defaultMQPushConsumer.getInstanceName());
                this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook(new OnsConsumeMessageHookImpl(this.traceDispatcher));
            }
            catch (Throwable e) {
                log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
            }
        }
    }

    @Override
    protected void updateNameServerAddr(String newAddrs) {
        this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(newAddrs);
    }

    void subscribe(String topic, String subExpression) {
        try {
            this.defaultMQPushConsumer.subscribe(topic, subExpression);
        }
        catch (MQClientException e) {
            throw new ONSClientException("defaultMQPushConsumer subscribe exception", e);
        }
    }

    void subscribe(String topic, MessageSelector selector) {
        com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector messageSelector;
        String subExpression = "*";
        String type = "TAG";
        if (selector != null) {
            if (selector.getType() == null) {
                throw new ONSClientException("Expression type is null!");
            }
            subExpression = selector.getSubExpression();
            type = selector.getType().name();
        }
        if ("SQL92".equals(type)) {
            messageSelector = com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector.bySql(subExpression);
        } else if ("TAG".equals(type)) {
            messageSelector = com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector.byTag(subExpression);
        } else {
            throw new ONSClientException(String.format("Expression type %s is unknown!", type));
        }
        try {
            this.defaultMQPushConsumer.subscribe(topic, messageSelector);
        }
        catch (MQClientException e) {
            throw new ONSClientException("Consumer subscribe exception", e);
        }
    }

    void unsubscribe(String topic) {
        this.defaultMQPushConsumer.unsubscribe(topic);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQPushConsumer.start();
            }
        }
        catch (Exception e) {
            throw new ONSClientException(e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQPushConsumer.shutdown();
        }
        super.shutdown();
    }
}

