/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.DataVersion;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public class Configuration {
    private final Logger log;
    private List<Object> configObjectList = new ArrayList<Object>(4);
    private String storePath;
    private boolean storePathFromConfig = false;
    private Object storePathObject;
    private Field storePathField;
    private DataVersion dataVersion = new DataVersion();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Properties allConfigs = new Properties();

    public Configuration(Logger log) {
        this.log = log;
    }

    public Configuration(Logger log, Object ... configObjects) {
        this.log = log;
        if (configObjects == null || configObjects.length == 0) {
            return;
        }
        for (Object configObject : configObjects) {
            this.registerConfig(configObject);
        }
    }

    public Configuration(Logger log, String storePath, Object ... configObjects) {
        this(log, configObjects);
        this.storePath = storePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration registerConfig(Object configObject) {
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                Properties registerProps = MixAll.object2Properties(configObject);
                this.merge(registerProps, this.allConfigs);
                this.configObjectList.add(configObject);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("registerConfig lock error");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration registerConfig(Properties extProperties) {
        if (extProperties == null) {
            return this;
        }
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.merge(extProperties, this.allConfigs);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("register lock error. {}" + extProperties);
        }
        return this;
    }

    public void setStorePathFromConfig(Object object, String fieldName) {
        assert (object != null);
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.storePathFromConfig = true;
                this.storePathObject = object;
                this.storePathField = object.getClass().getDeclaredField(fieldName);
                assert (this.storePathField != null && !Modifier.isStatic(this.storePathField.getModifiers()));
                this.storePathField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("setStorePathFromConfig lock error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStorePath() {
        String realStorePath = null;
        try {
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                realStorePath = this.storePath;
                if (this.storePathFromConfig) {
                    try {
                        realStorePath = (String)this.storePathField.get(this.storePathObject);
                    }
                    catch (IllegalAccessException e) {
                        this.log.error("getStorePath error, ", (Throwable)e);
                    }
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("getStorePath lock error");
        }
        return realStorePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Properties properties) {
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.mergeIfExist(properties, this.allConfigs);
                for (Object configObject : this.configObjectList) {
                    MixAll.properties2Object(properties, configObject);
                }
                this.dataVersion.nextVersion();
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("update lock error, {}", (Object)properties);
            return;
        }
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        try {
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                String allConfigs = this.getAllConfigsInternal();
                MixAll.string2File(allConfigs, this.getStorePath());
            }
            catch (IOException e) {
                this.log.error("persist string2File error, ", (Throwable)e);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("persist lock error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllConfigsFormatString() {
        this.readWriteLock.readLock().lockInterruptibly();
        try {
            String string = this.getAllConfigsInternal();
            this.readWriteLock.readLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                this.log.error("getAllConfigsFormatString lock error");
                return null;
            }
        }
    }

    public String getDataVersionJson() {
        return this.dataVersion.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getAllConfigs() {
        this.readWriteLock.readLock().lockInterruptibly();
        try {
            Properties properties = this.allConfigs;
            this.readWriteLock.readLock().unlock();
            return properties;
        }
        catch (Throwable throwable) {
            try {
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                this.log.error("getAllConfigs lock error");
                return null;
            }
        }
    }

    private String getAllConfigsInternal() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object configObject : this.configObjectList) {
            Properties properties = MixAll.object2Properties(configObject);
            if (properties != null) {
                this.merge(properties, this.allConfigs);
                continue;
            }
            this.log.warn("getAllConfigsInternal object2Properties is null, {}", configObject.getClass());
        }
        stringBuilder.append(MixAll.properties2String(this.allConfigs));
        return stringBuilder.toString();
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    private void merge(Properties from, Properties to) {
        for (Object key : from.keySet()) {
            Object fromObj = from.get(key);
            Object toObj = to.get(key);
            if (toObj != null && !toObj.equals(fromObj)) {
                this.log.info("Replace, key: {}, value: {} -> {}", new Object[]{key, toObj, fromObj});
            }
            to.put(key, fromObj);
        }
    }

    private void mergeIfExist(Properties from, Properties to) {
        for (Object key : from.keySet()) {
            if (!to.containsKey(key)) continue;
            Object fromObj = from.get(key);
            Object toObj = to.get(key);
            if (toObj != null && !toObj.equals(fromObj)) {
                this.log.info("Replace, key: {}, value: {} -> {}", new Object[]{key, toObj, fromObj});
            }
            to.put(key, fromObj);
        }
    }
}

