/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client.impl.queue;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.request.queue.BatchReceiveMessageRequest;
import com.aliyun.mns.model.serialize.queue.MessageListDeserializer;
import java.net.URI;
import java.util.Iterator;
import java.util.List;

public class BatchReceiveMessageAction
extends AbstractAction<BatchReceiveMessageRequest, List<Message>> {
    public BatchReceiveMessageAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "BatchReceiveMessage", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(BatchReceiveMessageRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        String uri = reqObject.getRequestPath() + "/" + "messages" + "?numOfMessages=" + reqObject.getBatchSize();
        if (reqObject.getWaitSeconds() > 0) {
            uri = uri + "&waitseconds=" + reqObject.getWaitSeconds();
        }
        requestMessage.setResourcePath(uri);
        return requestMessage;
    }

    @Override
    protected boolean validate(BatchReceiveMessageRequest request) {
        if (request.getBatchSize() <= 0) {
            throw new ClientException("BatchSize is invalid");
        }
        if (request.getWaitSeconds() < 0) {
            throw new ClientException("WaitSeconds is invalid");
        }
        return super.validate(request);
    }

    @Override
    protected ResultParser<List<Message>> buildResultParser() {
        return new ResultParser<List<Message>>(){

            @Override
            public List<Message> parse(ResponseMessage response) throws ResultParseException {
                MessageListDeserializer deserializer = new MessageListDeserializer();
                try {
                    Object msgs = deserializer.deserialize(response.getContent());
                    Iterator i$ = msgs.iterator();
                    while (i$.hasNext()) {
                        Message msg = (Message)i$.next();
                        msg.setRequestId(response.getHeader("x-mns-request-id"));
                    }
                    return msgs;
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

