/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.SourceInfo;
import com.alibaba.citrus.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceInfoSupport<P extends SourceInfo<?>>
implements SourceInfo<P> {
    private final P parent;
    private ResourceResolver.Resource source;
    private int lineNumber = -1;

    public SourceInfoSupport() {
        this.parent = null;
    }

    public SourceInfoSupport(P parent) {
        this.parent = (SourceInfo)Assert.assertNotNull(parent, "no parent sourceInfo provided", new Object[0]);
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    public SourceInfo<P> setSource(ResourceResolver.Resource source) {
        this.setSource(source, -1);
        return this;
    }

    public SourceInfo<P> setSource(ResourceResolver.Resource source, int lineNumber) {
        this.source = source;
        this.lineNumber = source != null && lineNumber > 0 ? lineNumber : -1;
        return this;
    }

    @Override
    public ResourceResolver.Resource getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        if (this.source != null) {
            if (this.lineNumber > 0) {
                return this.source + " (line " + this.lineNumber + ")";
            }
            return this.source.toString();
        }
        return this.getClass().getSimpleName();
    }
}

